/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.git;

import ch.admin.bit.jeap.messaging.avro.plugin.git.NewMessageTypeVersionDto;
import ch.admin.bit.jeap.messaging.avro.plugin.helper.TypeDescriptorFactory;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.TypeDescriptor;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.TypeVersion;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;

class NewMessageTypeDiff {
    NewMessageTypeDiff() {
    }

    static Set<NewMessageTypeVersionDto> findNewMessageTypeVersions(Path sourceDir, String descriptorPath, Git git, RevCommit newCommit, RevCommit baseCommit) throws MojoExecutionException {
        try {
            String newDescriptor = NewMessageTypeDiff.getContent(newCommit, descriptorPath, git);
            String baseDescriptor = NewMessageTypeDiff.getContent(baseCommit, descriptorPath, git);
            TypeDescriptor newTypeDescriptor = TypeDescriptorFactory.readTypeDescriptor(newDescriptor, descriptorPath);
            TypeDescriptor baseTypeDescriptor = TypeDescriptorFactory.readTypeDescriptor(baseDescriptor, descriptorPath);
            return NewMessageTypeDiff.diffMessageTypes(sourceDir, Path.of(descriptorPath, new String[0]), newTypeDescriptor, baseTypeDescriptor);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to read descriptor " + descriptorPath, (Exception)ex);
        }
    }

    static Set<NewMessageTypeVersionDto> diffMessageTypes(Path sourceDir, Path descriptorPath, TypeDescriptor newTypeDescriptor, TypeDescriptor baseTypeDescriptor) {
        Set<String> newVersions = NewMessageTypeDiff.getVersionNumbers(newTypeDescriptor);
        Set<String> baseVersions = NewMessageTypeDiff.getVersionNumbers(baseTypeDescriptor);
        newVersions.removeAll(baseVersions);
        String systemName = NewMessageTypeDiff.systemName(descriptorPath);
        Path absoluteDescriptorPath = sourceDir.resolve(descriptorPath);
        return newVersions.stream().map(v -> new NewMessageTypeVersionDto(systemName, absoluteDescriptorPath, newTypeDescriptor, (String)v)).collect(Collectors.toSet());
    }

    private static String systemName(Path path) {
        return path.subpath(1, 2).toString().toLowerCase(Locale.ROOT);
    }

    private static Set<String> getVersionNumbers(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return Set.of();
        }
        return typeDescriptor.getVersions().stream().map(TypeVersion::getVersion).collect(Collectors.toCollection(HashSet::new));
    }

    private static String getContent(RevCommit commit, String descriptorPath, Git git) throws IOException {
        Repository repository = git.getRepository();
        RevTree tree = commit.getTree();
        try (TreeWalk treeWalk = new TreeWalk(repository);){
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            if (!NewMessageTypeDiff.findFile(descriptorPath, treeWalk)) {
                String string = null;
                return string;
            }
            ObjectLoader loader = repository.open((AnyObjectId)treeWalk.getObjectId(0));
            String string = new String(loader.getBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private static boolean findFile(String descriptorPath, TreeWalk treeWalk) throws IOException {
        while (treeWalk.next()) {
            if (!treeWalk.getPathString().equals(descriptorPath)) continue;
            return true;
        }
        return false;
    }
}

