/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.helper;

import ch.admin.bit.jeap.messaging.avro.plugin.registry.CommandDescriptor;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.EventDescriptor;
import ch.admin.bit.jeap.messaging.avro.plugin.registry.TypeDescriptor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;

public class TypeDescriptorFactory {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static TypeDescriptor getTypeDescriptor(Path descriptor) throws MojoExecutionException {
        try {
            if (descriptor.getFileName().toString().endsWith("Event.json")) {
                return (TypeDescriptor)OBJECT_MAPPER.readValue(descriptor.toFile(), EventDescriptor.class);
            }
            if (descriptor.getFileName().toString().endsWith("Command.json")) {
                return (TypeDescriptor)OBJECT_MAPPER.readValue(descriptor.toFile(), CommandDescriptor.class);
            }
            throw new MojoExecutionException("Unknown descriptor type: " + String.valueOf(descriptor));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read value from json: " + e.getMessage(), (Exception)e);
        }
    }

    public static TypeDescriptor readTypeDescriptor(String jsonContent, String descriptorPath) throws MojoExecutionException {
        if (jsonContent == null) {
            return null;
        }
        try {
            if (descriptorPath.endsWith("Event.json")) {
                return (TypeDescriptor)OBJECT_MAPPER.readValue(jsonContent, EventDescriptor.class);
            }
            if (descriptorPath.endsWith("Command.json")) {
                return (TypeDescriptor)OBJECT_MAPPER.readValue(jsonContent, CommandDescriptor.class);
            }
            throw new MojoExecutionException("Unknown descriptor type: " + descriptorPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read value from json: " + e.getMessage(), (Exception)e);
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

