/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.git;

import ch.admin.bit.jeap.messaging.avro.plugin.git.GitDiffDto;
import ch.admin.bit.jeap.messaging.avro.plugin.git.NewMessageTypeDiff;
import ch.admin.bit.jeap.messaging.avro.plugin.git.NewMessageTypeVersionDto;
import ch.admin.bit.jeap.messaging.avro.plugin.git.ProcessBuilderFactory;
import ch.admin.bit.jeap.messaging.avro.plugin.git.RefComparableVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitClient {
    private final Log log;
    private final Repository repo;
    private final Git git;
    private final String remoteUrl;
    private final String trunkBranchName;
    private final String sourceDirectory;
    private final ProcessBuilderFactory processBuilderFactory;

    public GitClient(String sourceDirectory, String remoteUrl, String trunkBranchName, Log log) throws MojoExecutionException {
        this(sourceDirectory, remoteUrl, trunkBranchName, log, new ProcessBuilderFactory());
    }

    public GitClient(String sourceDirectory, String remoteUrl, String trunkBranchName, Log log, ProcessBuilderFactory processBuilderFactory) throws MojoExecutionException {
        this.sourceDirectory = sourceDirectory;
        this.log = log;
        this.remoteUrl = remoteUrl;
        this.trunkBranchName = trunkBranchName;
        this.processBuilderFactory = processBuilderFactory;
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            this.repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(sourceDirectory + "/.git"))).setMustExist(true)).build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot build repo " + e.getMessage(), (Exception)e);
        }
        this.git = new Git(this.repo);
    }

    public GitDiffDto getGitDiff(String branchName) throws MojoExecutionException {
        if (this.trunkBranchName.equals(branchName)) {
            return this.getDiffFromLastTag();
        }
        return this.getDiffFromTrunk();
    }

    public void gitFetchTags(String token) throws MojoExecutionException {
        if (token != null) {
            this.gitFetchTagsWithToken(token);
        } else {
            this.gitFetchTagsWithSystemGit();
        }
    }

    private void gitFetchTagsWithToken(String token) throws MojoExecutionException {
        this.log.info((CharSequence)"Using JGit with a token to fetch tags from the remote repository.");
        FetchCommand fetch = (FetchCommand)this.git.fetch().setRemote(this.remoteUrl).setRefSpecs(new RefSpec[]{new RefSpec("+refs/tags/*:refs/tags/*")}).setTagOpt(TagOpt.FETCH_TAGS).setForceUpdate(true).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider("no-username-with-token", token));
        try {
            fetch.call();
        }
        catch (GitAPIException e) {
            if (e.getMessage() != null && e.getMessage().contains("Nothing to fetch")) {
                this.log.info((CharSequence)"No new tags to fetch; repository is up-to-date.");
            }
            throw new MojoExecutionException("Cannot fetch tags: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void gitFetchTagsWithSystemGit() throws MojoExecutionException {
        this.log.info((CharSequence)"Using a system Git process to to fetch tags from the remote repository.");
        try {
            ProcessBuilder pb = this.processBuilderFactory.createProcessBuilder("git", "fetch", "--tags", "--force", this.remoteUrl);
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String message = "The Git fetch process failed to fetch the tags from the remote repository. Exit code: " + exitCode;
                throw new MojoExecutionException(message);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "Interrupted while waiting for the Git fetch tags process to finish.";
            throw new MojoExecutionException(message);
        }
        catch (IOException e) {
            String message = "Failed to fetch the tags from the remote repository using a Git process: " + e.getMessage();
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    protected GitDiffDto getDiffFromLastTag() throws MojoExecutionException {
        this.log.info((CharSequence)"Retrieve Git Diff from last tag...");
        return this.executeDiffBetweenCommits(this.retrieveLastCommitFromLastTag(), this.retrieveLastCommitFromCurrentBranch());
    }

    protected GitDiffDto getDiffFromTrunk() throws MojoExecutionException {
        this.log.info((CharSequence)("Retrieve Git Diff from " + this.trunkBranchName + " branch..."));
        return this.executeDiffBetweenCommits(this.retrieveLastCommitFromTrunk(), this.retrieveLastCommitFromCurrentBranch());
    }

    private RevCommit retrieveLastCommitFromCurrentBranch() throws MojoExecutionException {
        RevCommit revCommit;
        RevWalk walk = new RevWalk(this.repo);
        try {
            revCommit = walk.parseCommit((AnyObjectId)this.git.log().setMaxCount(1).call().iterator().next());
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GitAPIException e) {
                this.log.error((CharSequence)("Cannot retrieve current commit " + e.getMessage()), e);
                throw new MojoExecutionException("Cannot retrieve current commit " + e.getMessage(), (Exception)e);
            }
        }
        walk.close();
        return revCommit;
    }

    private RevCommit retrieveLastCommitFromTrunk() throws MojoExecutionException {
        try {
            return (RevCommit)this.git.log().add((AnyObjectId)this.repo.resolve("remotes/origin/" + this.trunkBranchName)).setMaxCount(1).call().iterator().next();
        }
        catch (IOException | GitAPIException e) {
            String errorMessage = "Cannot retrieve last commit from " + this.trunkBranchName + ": " + e.getMessage();
            this.log.error((CharSequence)errorMessage, e);
            throw new MojoExecutionException(errorMessage, (Exception)e);
        }
    }

    private RevCommit retrieveLastCommitFromLastTag() throws MojoExecutionException {
        try {
            this.log.debug((CharSequence)"get tags");
            List tags = this.git.tagList().call();
            this.log.debug((CharSequence)("found " + tags.size() + " tags"));
            Ref lastTag = GitClient.findMostRecentTag(tags);
            this.log.info((CharSequence)("last tag: " + lastTag.getName()));
            LogCommand logFromTag = this.git.log();
            Ref peeledRef = this.repo.getRefDatabase().peel(lastTag);
            if (peeledRef.getPeeledObjectId() != null) {
                logFromTag.add((AnyObjectId)peeledRef.getPeeledObjectId());
            } else {
                logFromTag.add((AnyObjectId)lastTag.getObjectId());
            }
            return (RevCommit)logFromTag.setMaxCount(1).call().iterator().next();
        }
        catch (IOException | GitAPIException e) {
            this.log.error((CharSequence)("Cannot retrieve last tag commits " + e.getMessage()), e);
            throw new MojoExecutionException("Cannot retrieve last tag commits " + e.getMessage(), (Exception)e);
        }
    }

    protected static Ref findMostRecentTag(Collection<Ref> tags) throws MojoExecutionException {
        RefComparableVersion lastTag = tags.stream().filter(t -> !t.getName().contains("-SNAPSHOT")).map(RefComparableVersion::new).max(RefComparableVersion::compareTo).orElseThrow(() -> new MojoExecutionException("Cannot find the most recent tag from the tags list"));
        return lastTag.getRef();
    }

    private GitDiffDto executeDiffBetweenCommits(RevCommit baseCommit, RevCommit newCommit) throws MojoExecutionException {
        try {
            this.log.debug((CharSequence)("LogCommit: " + String.valueOf(baseCommit)));
            this.log.debug((CharSequence)("LogMessage: " + baseCommit.getFullMessage()));
            this.log.debug((CharSequence)("LogCommit: " + String.valueOf(newCommit)));
            this.log.debug((CharSequence)("LogMessage: " + newCommit.getFullMessage()));
            AbstractTreeIterator oldTreeIterator = this.getCanonicalTreeParser(this.git, (ObjectId)baseCommit);
            AbstractTreeIterator newTreeIterator = this.getCanonicalTreeParser(this.git, (ObjectId)newCommit);
            List<DiffEntry> deltas = this.git.diff().setOldTree(oldTreeIterator).setNewTree(newTreeIterator).call().stream().filter(GitClient::isDescriptor).toList();
            HashSet<NewMessageTypeVersionDto> newMessageTypeVersions = new HashSet<NewMessageTypeVersionDto>();
            for (DiffEntry delta : deltas) {
                String changedFilePath = delta.getNewPath();
                Set<NewMessageTypeVersionDto> versions = NewMessageTypeDiff.findNewMessageTypeVersions(Path.of(this.sourceDirectory, new String[0]), changedFilePath, this.git, newCommit, baseCommit);
                newMessageTypeVersions.addAll(versions);
            }
            return new GitDiffDto(newMessageTypeVersions);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Cannot read tree " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Cannot read tree " + e.getMessage(), (Exception)e);
        }
        catch (GitAPIException e) {
            this.log.error((CharSequence)("Cannot retrieve Git information " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Cannot retrieve Git information " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private static boolean isDescriptor(DiffEntry d) {
        return d.getNewPath().startsWith("descriptor/") && d.getNewPath().endsWith(".json");
    }

    private AbstractTreeIterator getCanonicalTreeParser(Git git, ObjectId commitId) throws IOException {
        try (RevWalk walk = new RevWalk(git.getRepository());){
            CanonicalTreeParser canonicalTreeParser;
            block11: {
                RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
                ObjectId treeId = commit.getTree().getId();
                ObjectReader reader = git.getRepository().newObjectReader();
                try {
                    canonicalTreeParser = new CanonicalTreeParser(null, reader, (AnyObjectId)treeId);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return canonicalTreeParser;
        }
    }
}

