/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.helper;

import ch.admin.bit.jeap.messaging.avro.plugin.helper.RegistryHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class GeneratedSourcesCleaner {
    private final Log log = new SystemStreamLog();

    public void cleanupDuplicatedCommonFiles(File outputDirectory, Map<String, List<Path>> commonDefinitionsPerSystem) throws MojoExecutionException {
        if (!outputDirectory.exists()) {
            return;
        }
        this.log.debug((CharSequence)"Cleanup duplicated common files");
        int countCleanUpFiles = 0;
        List<Path> generatedSources = this.retrieveAllGeneratedClasses(outputDirectory);
        try {
            List<String> commonFiles = commonDefinitionsPerSystem.values().stream().flatMap(Collection::stream).map(cf -> RegistryHelper.convertFileNameOfAVDLToFilePathOfJava(cf.getFileName().toString())).toList();
            block2: for (Path current : generatedSources) {
                for (String alreadyCommonFile : commonFiles) {
                    if (!current.endsWith(alreadyCommonFile) || current.toString().contains("_common")) continue;
                    Files.deleteIfExists(current);
                    ++countCleanUpFiles;
                    continue block2;
                }
            }
            this.log.info((CharSequence)("Cleanup deleted " + countCleanUpFiles + " duplicated files"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot cleanup: " + e.getMessage(), (Exception)e);
        }
    }

    private List<Path> retrieveAllGeneratedClasses(File classesDirectory) throws MojoExecutionException {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.walk(Paths.get(classesDirectory.getAbsolutePath(), new String[0]), Integer.MAX_VALUE, new FileVisitOption[0]);
            try {
                list = stream.filter(path -> FilenameUtils.getExtension((String)path.getFileName().toString()).equals("java")).toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot walk through classes directory: " + e.getMessage(), (Exception)e);
                }
            }
            stream.close();
        }
        return list;
    }
}

