/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.validator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ValidationResult {
    private static final ValidationResult OK = new ValidationResult(true, Collections.emptyList());
    private final boolean valid;
    private final List<String> errors;

    public static ValidationResult ok() {
        return OK;
    }

    public static ValidationResult fail(String error) {
        return new ValidationResult(false, Collections.singletonList(error));
    }

    public static ValidationResult merge(ValidationResult ... res) {
        return Arrays.stream(res).reduce(ValidationResult.ok(), ValidationResult::merge);
    }

    private static ValidationResult merge(ValidationResult res1, ValidationResult res2) {
        List<String> errors = Stream.concat(res1.getErrors().stream(), res2.getErrors().stream()).collect(Collectors.toList());
        boolean valid = res1.isValid() && res2.isValid();
        return new ValidationResult(valid, errors);
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationResult(valid=" + this.isValid() + ", errors=" + String.valueOf(this.getErrors()) + ")";
    }

    @Generated
    private ValidationResult(boolean valid, List<String> errors) {
        this.valid = valid;
        this.errors = errors;
    }
}

