/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.validator;

import ch.admin.bit.jeap.messaging.avro.plugin.validator.FieldTypeValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.SingleFieldTypeValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.ValidationResult;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.avro.Schema;

class RecordValidator {
    private final List<FieldTypeValidator> fieldValidators;
    private boolean hasNoOther;

    static RecordValidator create() {
        return new RecordValidator(new LinkedList<FieldTypeValidator>(), false);
    }

    FieldTypeValidator required(String name) {
        SingleFieldTypeValidator fv = new SingleFieldTypeValidator(this, name, true);
        this.fieldValidators.add(fv);
        return fv;
    }

    FieldTypeValidator optional(String name) {
        SingleFieldTypeValidator fv = new SingleFieldTypeValidator(this, name, false);
        fv.canBeOptional();
        this.fieldValidators.add(fv);
        return fv;
    }

    FieldTypeValidator forAll() {
        FieldTypeValidator fv = new FieldTypeValidator(this);
        this.fieldValidators.add(fv);
        return fv;
    }

    RecordValidator noOtherFields() {
        this.hasNoOther = true;
        return this;
    }

    public ValidationResult validate(Schema schema) {
        return ValidationResult.merge(new ValidationResult[]{this.fieldValidators.stream().map(v -> v.validate(schema)).reduce(ValidationResult.ok(), (xva$0, xva$1) -> ValidationResult.merge(new ValidationResult[]{xva$0, xva$1})), this.validateNoOther(schema)});
    }

    private ValidationResult validateNoOther(Schema schema) {
        if (!this.hasNoOther) {
            return ValidationResult.ok();
        }
        List<String> names = this.fieldValidators.stream().filter(SingleFieldTypeValidator.class::isInstance).map(f -> (SingleFieldTypeValidator)f).map(SingleFieldTypeValidator::getName).toList();
        return schema.getFields().stream().map(Schema.Field::name).filter(name -> !names.contains(name)).map(name -> String.format("Field '%s' in schema '%s' is not allowed, only fields %s are.", name, schema.getName(), names)).map(ValidationResult::fail).reduce(ValidationResult.ok(), (xva$0, xva$1) -> ValidationResult.merge(new ValidationResult[]{xva$0, xva$1}));
    }

    @Generated
    private RecordValidator(List<FieldTypeValidator> fieldValidators, boolean hasNoOther) {
        this.fieldValidators = fieldValidators;
        this.hasNoOther = hasNoOther;
    }
}

