/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.validator;

import ch.admin.bit.jeap.messaging.avro.plugin.validator.FieldTypeValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.RecordValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.ValidationResult;
import lombok.Generated;
import org.apache.avro.Schema;

class SingleFieldTypeValidator
extends FieldTypeValidator {
    private final String name;
    private final boolean required;

    SingleFieldTypeValidator(RecordValidator recordValidator, String name, boolean required) {
        super(recordValidator);
        this.name = name;
        this.required = required;
    }

    @Override
    ValidationResult validate(Schema schema) {
        Schema.Field field = schema.getField(this.name);
        if (field == null && !this.required) {
            return ValidationResult.ok();
        }
        if (field == null) {
            String message = String.format("No field '%s' in schema '%s' but it is required", this.name, schema.getName());
            return ValidationResult.fail(message);
        }
        return super.validate(schema, field);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

