/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.validator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;

public class RecordCollection {
    private final List<Schema> records = new LinkedList<Schema>();

    public static RecordCollection of(Schema schema) {
        RecordCollection ret = new RecordCollection();
        ret.collectRecords(schema);
        return ret;
    }

    public static RecordCollection of(Protocol protocols) {
        RecordCollection ret = new RecordCollection();
        protocols.getTypes().forEach(ret::collectRecords);
        return ret;
    }

    public List<Schema> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    private void collectRecords(Schema schema) {
        if (this.records.contains(schema)) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.records.add(schema);
                for (Schema.Field field : schema.getFields()) {
                    this.collectRecords(field.schema());
                }
                break;
            }
            case MAP: {
                this.collectRecords(schema.getValueType());
                break;
            }
            case ARRAY: {
                this.collectRecords(schema.getElementType());
                break;
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    this.collectRecords(s);
                }
                break;
            }
        }
    }

    @Generated
    private RecordCollection() {
    }
}

