/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro.plugin.validator;

import ch.admin.bit.jeap.messaging.avro.plugin.validator.RecordValidator;
import ch.admin.bit.jeap.messaging.avro.plugin.validator.ValidationResult;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

class FieldTypeValidator {
    private final RecordValidator validator;
    private Set<String> types = Set.of();
    private boolean canBeOptional;
    private boolean canBeArray;
    private String namespace;
    private String typeSuffix;
    private LogicalType logicalType;

    FieldTypeValidator type(String type) {
        return this.anyTypeOf(type);
    }

    FieldTypeValidator anyTypeOf(String ... validTypes) {
        this.types = Set.of(validTypes);
        return this;
    }

    FieldTypeValidator canBeOptional() {
        this.canBeOptional = true;
        return this;
    }

    FieldTypeValidator canBeArray() {
        this.canBeArray = true;
        return this;
    }

    FieldTypeValidator namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    FieldTypeValidator typeSuffix(String typeSuffix) {
        this.typeSuffix = typeSuffix;
        return this;
    }

    FieldTypeValidator logicalType(LogicalType logicalType) {
        this.logicalType = logicalType;
        return this;
    }

    RecordValidator end() {
        return this.validator;
    }

    ValidationResult validate(Schema schema) {
        return schema.getFields().stream().map(f -> this.validate(schema, (Schema.Field)f)).reduce(ValidationResult.ok(), (xva$0, xva$1) -> ValidationResult.merge(new ValidationResult[]{xva$0, xva$1}));
    }

    final ValidationResult validate(Schema schema, Schema.Field field) {
        return ValidationResult.merge(this.checkMatchesTypes(schema, field), this.checkNamespace(schema, field), this.checkTypeSuffix(schema, field), this.checkLogicalType(schema, field));
    }

    private ValidationResult checkMatchesTypes(Schema schema, Schema.Field field) {
        if (this.types.isEmpty()) {
            return ValidationResult.ok();
        }
        if (this.types.contains(this.getTypeName(field))) {
            return ValidationResult.ok();
        }
        if (this.canBeOptional && field.schema().isUnion()) {
            return this.isValidOptional(schema, field, s -> this.types.contains(s), String.format("must be (<one of: %s>, null)", this.types));
        }
        if (this.canBeArray && field.schema().getType() == Schema.Type.ARRAY) {
            return this.isValidArray(schema, field, s -> this.types.contains(s), String.format("must be array<one of: %s>", this.types.toString()));
        }
        String message = String.format("Field '%s' in schema '%s' has type '%s' but required is one of %s", field.name(), schema.getName(), field.schema().getName(), this.types);
        return ValidationResult.fail(message);
    }

    private String getTypeName(Schema.Field field) {
        Object typeName = field.schema().getName();
        if (Schema.Type.MAP == field.schema().getType()) {
            String mapValueType = field.schema().getValueType().getName();
            typeName = (String)typeName + "<" + mapValueType + ">";
        }
        return typeName;
    }

    private ValidationResult isValidArray(Schema schema, Schema.Field field, Predicate<String> validator, String failMessage) {
        Schema elementType = field.schema().getElementType();
        if (validator.test(elementType.getName())) {
            return ValidationResult.ok();
        }
        return ValidationResult.fail(String.format("Array field '%s' in schema '%s' is invalid: %s", field.name(), schema.getName(), failMessage));
    }

    private ValidationResult isValidOptional(Schema schema, Schema.Field field, Predicate<String> validator, String failMessage) {
        List schemaTypes = field.schema().getTypes();
        List<String> nameTypes = schemaTypes.stream().map(s -> this.canBeArray && s.getName().equals("array") ? s.getElementType().getName() : s.getName()).toList();
        if (schemaTypes.size() != 2 || !nameTypes.contains("null") || nameTypes.stream().allMatch("null"::equals)) {
            String message = String.format("Field '%s' in schema '%s' is union(%s) but must contain 'null' and one type", field.name(), schema.getName(), String.join((CharSequence)",", nameTypes));
            return ValidationResult.fail(message);
        }
        return nameTypes.stream().filter(t -> !t.equals("null")).filter(t -> !validator.test((String)t)).map(t -> String.format(failMessage, t)).map(t -> String.format("Field '%s' in schema '%s' is union(%s) but %s", field.name(), schema.getName(), String.join((CharSequence)",", nameTypes), failMessage)).map(ValidationResult::fail).reduce(ValidationResult.ok(), (xva$0, xva$1) -> ValidationResult.merge(new ValidationResult[]{xva$0, xva$1}));
    }

    private ValidationResult checkNamespace(Schema schema, Schema.Field field) {
        if (this.namespace == null) {
            return ValidationResult.ok();
        }
        try {
            if (field.schema().getNamespace().equals(this.namespace)) {
                return ValidationResult.ok();
            }
            String message = String.format("Field '%s' in schema '%s' has namespace '%s' but required is '%s'", field.name(), schema.getName(), field.schema().getNamespace(), this.namespace);
            return ValidationResult.fail(message);
        }
        catch (AvroRuntimeException e) {
            String message = String.format("Cannot check namespace of field '%s' in schema '%s' but must be '%s'", field.name(), schema.getName(), this.namespace);
            return ValidationResult.fail(message);
        }
    }

    private ValidationResult checkTypeSuffix(Schema schema, Schema.Field field) {
        if (this.typeSuffix == null) {
            return ValidationResult.ok();
        }
        if (field.schema().getName().endsWith(this.typeSuffix)) {
            return ValidationResult.ok();
        }
        if (this.canBeOptional && field.schema().isUnion()) {
            return this.isValidOptional(schema, field, s -> s.endsWith(this.typeSuffix), String.format("type must end with '%s'", this.typeSuffix));
        }
        if (this.canBeArray && field.schema().getType() == Schema.Type.ARRAY) {
            return this.isValidArray(schema, field, s -> s.endsWith(this.typeSuffix), String.format("array element type must end with '%s'", this.typeSuffix));
        }
        String message = String.format("Field '%s' in schema '%s' has type '%s' but type must end with '%s'", field.name(), schema.getName(), field.schema().getName(), this.typeSuffix);
        return ValidationResult.fail(message);
    }

    private ValidationResult checkLogicalType(Schema schema, Schema.Field field) {
        if (this.logicalType == null) {
            return ValidationResult.ok();
        }
        if (field.schema().getLogicalType() == null) {
            String message = String.format("Field '%s' in schema '%s' has no logical type but must have '%s'", field.name(), schema.getName(), this.logicalType.getName());
            return ValidationResult.fail(message);
        }
        if (field.schema().getLogicalType().equals(this.logicalType)) {
            return ValidationResult.ok();
        }
        String message = String.format("Field '%s' in schema '%s' has logical type '%s' but must be '%s'", field.name(), schema.getName(), field.schema().getLogicalType().getName(), this.logicalType.getName());
        return ValidationResult.fail(message);
    }

    @Generated
    FieldTypeValidator(RecordValidator validator) {
        this.validator = validator;
    }
}

