/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.domainevent.avro;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEvent;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventIdentity;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventPublisher;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventType;
import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventUser;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilder;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilderException;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AvroDomainEventBuilder<BuilderType extends AvroDomainEventBuilder, EventType extends AvroDomainEvent>
extends AvroMessageBuilder<BuilderType, EventType> {
    private static final String DOMAIN_EVENT_VERSION = "1.2.0";
    private AvroDomainEventUser user;

    protected AvroDomainEventBuilder(Supplier<EventType> constructor) {
        super(constructor);
    }

    @Deprecated(forRemoval=true, since="3.7.0")
    protected String getEventVersion() {
        return null;
    }

    public BuilderType user(AvroDomainEventUser user) {
        this.user = user;
        return (BuilderType)((AvroDomainEventBuilder)this.self());
    }

    public EventType build() {
        this.checkMandatoryFields();
        AvroDomainEvent event = (AvroDomainEvent)this.constructor.get();
        event.setIdentity(this.buildIdentity());
        event.setPublisher(this.buildPublisher());
        event.setType(this.buildType(event));
        event.setDomainEventVersion(DOMAIN_EVENT_VERSION);
        if (this.user != null) {
            event.setUser(this.user);
        }
        this.addCommon(event);
        return (EventType)event;
    }

    private AvroDomainEventIdentity buildIdentity() {
        AvroDomainEventIdentity identity = new AvroDomainEventIdentity();
        identity.setCreated(Instant.now());
        identity.setEventId(UUID.randomUUID().toString());
        identity.setIdempotenceId(this.idempotenceId);
        return identity;
    }

    private AvroDomainEventPublisher buildPublisher() {
        String serviceName = this.getServiceName();
        String systemName = this.getSystemName();
        AvroDomainEventPublisher publisher = new AvroDomainEventPublisher();
        publisher.setService(serviceName);
        publisher.setSystem(systemName);
        return publisher;
    }

    private AvroDomainEventType buildType(EventType event) {
        String name = event.getSchema().getName();
        String version = this.getGeneratedOrSpecifiedVersion((AvroMessage)event);
        if (version == null) {
            version = this.getEventVersion();
        }
        if (AvroDomainEventBuilder.isBlank(version)) {
            throw AvroMessageBuilderException.propertyValue("type.version", version);
        }
        AvroDomainEventType type = new AvroDomainEventType();
        type.setName(name);
        type.setVersion(version);
        return type;
    }
}

