/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public final class AvroSerializationHelper {
    public static byte[] serialize(AvroMessage event) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            Schema schema = event.getSchema();
            SpecificDatumWriter writer = new SpecificDatumWriter(schema);
            writer.write((Object)event, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static <T extends AvroMessage> T deserialize(byte[] message, Class<T> eventClass) throws ReflectiveOperationException, IOException {
        Schema schema = ((AvroMessage)eventClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSchema();
        SpecificDatumReader reader = new SpecificDatumReader(schema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(message, null);
        return (T)((AvroMessage)reader.read(null, (Decoder)decoder));
    }

    @Generated
    private AvroSerializationHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

