/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MessageVersionAccessor {
    static final Map<Class<?>, String> MESSAGE_TYPE_VERSION_CACHE = new ConcurrentHashMap();
    private static final String NO_GENERATED_VERSION_NULL_OBJECT = "__no_generated__version__";

    private MessageVersionAccessor() {
    }

    public static String getGeneratedVersion(Class<?> messageClass) {
        String version = MESSAGE_TYPE_VERSION_CACHE.computeIfAbsent(messageClass, type -> MessageVersionAccessor.getGeneratedVersionFieldValue(messageClass));
        return version.equals(NO_GENERATED_VERSION_NULL_OBJECT) ? null : version;
    }

    private static String getGeneratedVersionFieldValue(Class<?> messageClass) {
        try {
            Field messageTypeVersionField = messageClass.getField("MESSAGE_TYPE_VERSION$");
            messageTypeVersionField.setAccessible(true);
            String version = (String)messageTypeVersionField.get(null);
            boolean isValidVersion = version != null && !version.isBlank();
            return isValidVersion ? version : NO_GENERATED_VERSION_NULL_OBJECT;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            return NO_GENERATED_VERSION_NULL_OBJECT;
        }
    }
}

