/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.avro;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilderException;
import ch.admin.bit.jeap.messaging.avro.MessageVersionAccessor;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.messaging.model.MessageReferences;
import java.util.function.Supplier;
import lombok.Generated;

public abstract class AvroMessageBuilder<BuilderType extends AvroMessageBuilder, MessageType extends AvroMessage> {
    protected final Supplier<MessageType> constructor;
    protected String idempotenceId;
    private MessagePayload payload;
    private MessageReferences references;
    private String processId;

    protected abstract String getServiceName();

    protected abstract String getSystemName();

    protected abstract BuilderType self();

    protected void setPayload(MessagePayload payload) {
        this.payload = payload;
    }

    protected void setReferences(MessageReferences references) {
        this.references = references;
    }

    protected void setProcessId(String processId) {
        this.processId = processId;
    }

    protected String getSpecifiedMessageTypeVersion() {
        return null;
    }

    public BuilderType idempotenceId(String idempotenceId) {
        if (AvroMessageBuilder.isBlank(idempotenceId)) {
            throw AvroMessageBuilderException.propertyValue("identity.idempotenceId", idempotenceId);
        }
        this.idempotenceId = idempotenceId;
        return this.self();
    }

    protected void checkMandatoryFields() {
        if (AvroMessageBuilder.isBlank(this.idempotenceId)) {
            throw AvroMessageBuilderException.propertyValue("identity.idempotenceId", this.idempotenceId);
        }
        String serviceName = this.getServiceName();
        if (AvroMessageBuilder.isBlank(serviceName)) {
            throw AvroMessageBuilderException.propertyValue("publisher.serviceName", serviceName);
        }
        String systemName = this.getSystemName();
        if (AvroMessageBuilder.isBlank(systemName)) {
            throw AvroMessageBuilderException.propertyValue("publisher.systemName", systemName);
        }
    }

    protected String getGeneratedOrSpecifiedVersion(AvroMessage message) {
        String version = MessageVersionAccessor.getGeneratedVersion(message.getClass());
        if (version == null) {
            version = this.getSpecifiedMessageTypeVersion();
        }
        return version;
    }

    protected void addCommon(MessageType message) {
        if (this.references != null) {
            message.setReferences(this.references);
        }
        if (this.payload != null) {
            message.setPayload(this.payload);
        }
        if (this.processId != null) {
            message.setProcessId(this.processId);
        }
    }

    protected static boolean isBlank(CharSequence cs) {
        int strLen;
        int n = strLen = cs == null ? 0 : cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Generated
    protected AvroMessageBuilder(Supplier<MessageType> constructor) {
        this.constructor = constructor;
    }
}

