package ch.admin.bit.jeap.messaging.avro;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Provides the message version from the messages type registry,
 * as generated by the jEAP avro messaging maven plugin.
 */
public final class MessageVersionAccessor {
    static final Map<Class<?>, String> MESSAGE_TYPE_VERSION_CACHE = new ConcurrentHashMap<>();
    private static final String NO_GENERATED_VERSION_NULL_OBJECT = "__no_generated__version__";

    private MessageVersionAccessor() {
    }

    public static String getGeneratedVersion(Class<?> messageClass) {
        String version = MESSAGE_TYPE_VERSION_CACHE.computeIfAbsent(messageClass,
                type -> getGeneratedVersionFieldValue(messageClass));
        return version.equals(NO_GENERATED_VERSION_NULL_OBJECT) ? null : version;
    }

    private static String getGeneratedVersionFieldValue(Class<?> messageClass) {
        try {
            Field messageTypeVersionField = messageClass.getField("MESSAGE_TYPE_VERSION$");
            messageTypeVersionField.setAccessible(true);
            String version = (String) messageTypeVersionField.get(null);
            boolean isValidVersion = version != null && !version.isBlank();
            return isValidVersion ? version : NO_GENERATED_VERSION_NULL_OBJECT;
        } catch (NoSuchFieldException | IllegalAccessException | ClassCastException e) {
            // A null object is used - when there is no version field - to be able to differentiate between the cache
            // states:
            // - Not yet cached (null)
            // - Cached, but no version field available (null object)
            return NO_GENERATED_VERSION_NULL_OBJECT;
        }
    }
}
