/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.command.avro;

import ch.admin.bit.jeap.command.avro.AvroCommand;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilder;
import ch.admin.bit.jeap.messaging.avro.AvroMessageBuilderException;
import ch.admin.bit.jeap.messaging.avro.AvroMessageIdentity;
import ch.admin.bit.jeap.messaging.avro.AvroMessagePublisher;
import ch.admin.bit.jeap.messaging.avro.AvroMessageType;
import ch.admin.bit.jeap.messaging.avro.AvroMessageUser;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AvroCommandBuilder<BuilderType extends AvroCommandBuilder, CommandType extends AvroCommand>
extends AvroMessageBuilder<BuilderType, CommandType> {
    private static final String COMMAND_VERSION = "1.3.0";
    private AvroMessageUser user;

    protected AvroCommandBuilder(Supplier<CommandType> constructor) {
        super(constructor);
    }

    @Deprecated(forRemoval=true, since="3.7.0")
    protected String getCommandTypeVersion() {
        return null;
    }

    public BuilderType user(AvroMessageUser user) {
        this.user = user;
        return (BuilderType)((AvroCommandBuilder)this.self());
    }

    public CommandType build() {
        AvroCommand command = (AvroCommand)this.constructor.get();
        command.setIdentity(this.buildIdentity());
        command.setPublisher(this.buildPublisher());
        command.setType(this.buildType(command));
        command.setCommandVersion(COMMAND_VERSION);
        if (this.user != null) {
            command.setUser(this.user);
        }
        this.addCommon(command);
        return (CommandType)command;
    }

    private AvroMessageIdentity buildIdentity() {
        AvroMessageIdentity identity = new AvroMessageIdentity();
        identity.setCreated(Instant.now());
        identity.setId(UUID.randomUUID().toString());
        identity.setIdempotenceId(this.idempotenceId);
        return identity;
    }

    private AvroMessagePublisher buildPublisher() {
        String serviceName = this.getServiceName();
        String systemName = this.getSystemName();
        AvroMessagePublisher publisher = new AvroMessagePublisher();
        publisher.setService(serviceName);
        publisher.setSystem(systemName);
        return publisher;
    }

    private AvroMessageType buildType(CommandType command) {
        String name = command.getSchema().getName();
        String version = this.getGeneratedOrSpecifiedVersion((AvroMessage)command);
        if (version == null) {
            version = this.getCommandTypeVersion();
        }
        if (AvroCommandBuilder.isBlank(version)) {
            throw AvroMessageBuilderException.propertyValue("type.version", version);
        }
        AvroMessageType type = new AvroMessageType();
        type.setName(name);
        type.setVersion(version);
        type.setVariant(this.variant);
        return type;
    }
}

