/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth.aws.iam;

import ch.admin.bit.jeap.messaging.kafka.auth.KafkaAuthProperties;
import ch.admin.bit.jeap.messaging.kafka.auth.KafkaTrustStoreUtility;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.MskAuthProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import software.amazon.msk.auth.iam.IAMClientCallbackHandler;
import software.amazon.msk.auth.iam.IAMLoginModule;

public class AwsMskKafkaAuthProperties
implements KafkaAuthProperties {
    private static final String AWS_MSK_IAM = "AWS_MSK_IAM";
    private final KafkaProperties kafkaProperties;
    @Value(value="${spring.application.name}")
    private String sessionName;

    public AwsMskKafkaAuthProperties(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }

    public Map<String, Object> authenticationProperties(String clusterName) {
        ClusterProperties clusterProperties = (ClusterProperties)this.kafkaProperties.clusterProperties(clusterName).orElseThrow();
        MskAuthProperties mskAuthProperties = clusterProperties.getAws().getMsk();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("security.protocol", SecurityProtocol.SASL_SSL.name());
        KafkaTrustStoreUtility.setTrustStorePropertiesFromSystemProperties(props, (boolean)false, (boolean)false);
        props.put("sasl.mechanism", AWS_MSK_IAM);
        props.put("sasl.jaas.config", this.createSaslJaasConfig(mskAuthProperties));
        props.put("sasl.client.callback.handler.class", IAMClientCallbackHandler.class.getName());
        return props;
    }

    private String createSaslJaasConfig(MskAuthProperties mskAuthProperties) {
        if (mskAuthProperties.useAssumeRoleForAuth()) {
            if (!StringUtils.hasText((String)this.sessionName)) {
                throw new IllegalStateException("Session name is required when using assume-role IAM auth - please set spring.application.name");
            }
            return String.format("%s required awsRoleArn=\"%s\" awsRoleSessionName=\"%s\" awsStsRegion=\"%s\";", IAMLoginModule.class.getName(), mskAuthProperties.getAssumeIamRoleArn(), this.sessionName, mskAuthProperties.getRegion());
        }
        return String.format("%s required;", IAMLoginModule.class.getName());
    }
}

