/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.auth.aws.iam;

import ch.admin.bit.jeap.messaging.auth.aws.iam.util.IAMRolesAnywhereCredentialsProviderHolder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import lombok.NonNull;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.msk.auth.iam.internals.AWSCredentialsCallback;

public class IAMRolesAnywhereCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(IAMRolesAnywhereCallbackHandler.class);
    private AwsCredentialsProvider provider;

    public void configure(Map<String, ?> configs, @NonNull String saslMechanism, @NonNull List<AppConfigurationEntry> jaasConfigEntries) {
        if (saslMechanism == null) {
            throw new NullPointerException("saslMechanism is marked non-null but is null");
        }
        if (jaasConfigEntries == null) {
            throw new NullPointerException("jaasConfigEntries is marked non-null but is null");
        }
        if (!"AWS_MSK_IAM".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        log.info("Configured IAM Roles Any Where Callback Handler");
        this.provider = IAMRolesAnywhereCredentialsProviderHolder.getProvider();
    }

    public void close() {
        try {
            if (this.provider instanceof AutoCloseable) {
                ((AutoCloseable)this.provider).close();
            }
        }
        catch (Exception e) {
            log.warn("Error closing provider", (Throwable)e);
        }
    }

    public void handle(@NonNull Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            throw new NullPointerException("callbacks is marked non-null but is null");
        }
        for (Callback callback : callbacks) {
            log.debug("Type information for callback: {} from {}", (Object)IAMRolesAnywhereCallbackHandler.debugClassString(callback.getClass()), (Object)IAMRolesAnywhereCallbackHandler.debugClassString(this.getClass()));
            if (!(callback instanceof AWSCredentialsCallback)) {
                String message = "Unsupported callback type: " + IAMRolesAnywhereCallbackHandler.debugClassString(callback.getClass()) + " from " + IAMRolesAnywhereCallbackHandler.debugClassString(this.getClass());
                log.error(message);
                throw new UnsupportedCallbackException(callback, message);
            }
            this.handleCallback((AWSCredentialsCallback)callback);
        }
    }

    protected static String debugClassString(Class<?> clazz) {
        return "class: " + clazz.getName() + " classloader: " + clazz.getClassLoader().toString();
    }

    protected void handleCallback(AWSCredentialsCallback callback) throws IOException {
        log.debug("Selecting provider {} to load credentials", (Object)this.provider.getClass().getName());
        try {
            callback.setAwsCredentials(this.provider.resolveCredentials());
        }
        catch (Exception e) {
            callback.setLoadingException(e);
        }
    }
}

