/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue.config;

import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.AwsProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.GlueProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProvider;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueAvroDeserializer;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueAvroSerializer;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.config.auth.GlueAssumeRoleAuthProvider;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.config.auth.GlueAuthProvider;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.config.properties.GlueKafkaAvroSerdeProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureAuthenticityService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureService;
import ch.admin.bit.jeap.messaging.kafka.spring.AbstractSchemaRegistryBeanRegistrar;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.util.HashMap;
import lombok.Generated;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class GlueSchemaRegistryBeanRegistrar
extends AbstractSchemaRegistryBeanRegistrar {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryBeanRegistrar.class);
    private static final boolean IS_VALUE = false;
    private static final boolean IS_KEY = true;

    protected boolean shouldRegisterSchemaRegistryBeansForCluster(ClusterProperties clusterProperties) {
        AwsProperties aws = clusterProperties.getAws();
        return aws != null && aws.getGlue() != null && aws.getGlue().isActive();
    }

    protected KafkaAvroSerdeProvider createKafkaAvroSerializerProvider(String clusterName, JeapKafkaAvroSerdeCryptoConfig cryptoConfig) {
        GlueProperties glueProperties = ((ClusterProperties)this.kafkaProperties.clusterProperties(clusterName).orElseThrow()).getAws().getGlue();
        AwsCredentialsProvider awsCredentialsProvider = (AwsCredentialsProvider)this.beanFactory.getBean(AwsCredentialsProvider.class);
        ObjectProvider signatureServiceObjectProvider = this.beanFactory.getBeanProvider(SignatureService.class);
        ObjectProvider signatureAuthenticityServiceObjectProvider = this.beanFactory.getBeanProvider(SignatureAuthenticityService.class);
        SignatureService signatureService = (SignatureService)signatureServiceObjectProvider.getIfAvailable();
        SignatureAuthenticityService signatureAuthenticityService = (SignatureAuthenticityService)signatureAuthenticityServiceObjectProvider.getIfAvailable();
        GlueAuthProvider glueAuthProvider = this.glueAuthProvider(awsCredentialsProvider, glueProperties);
        AwsCredentialsProvider glueCredentialsProvider = glueAuthProvider.getAwsCredentialsProvider();
        GlueKafkaAvroSerdeProperties serdeProperties = this.kafkaAvroSerdeProperties(this.kafkaProperties, glueProperties, glueCredentialsProvider, cryptoConfig, signatureAuthenticityService);
        log.debug("Creating Avro serializers with config {}", serdeProperties.avroSerializerProperties(clusterName));
        log.debug("Creating Avro deserializers with config {}", serdeProperties.avroDeserializerProperties(clusterName));
        JeapGlueAvroSerializer valueSerializer = new JeapGlueAvroSerializer(glueCredentialsProvider, cryptoConfig, signatureService);
        valueSerializer.configure(serdeProperties.avroSerializerProperties(clusterName), false);
        JeapGlueAvroSerializer keySerializer = new JeapGlueAvroSerializer(glueCredentialsProvider, cryptoConfig, signatureService);
        keySerializer.configure(serdeProperties.avroSerializerProperties(clusterName), true);
        Deserializer<GenericData.Record> genericRecordDataDeserializer = GlueSchemaRegistryBeanRegistrar.createGenericRecordDataDeserializer(clusterName, glueCredentialsProvider, serdeProperties);
        return new KafkaAvroSerdeProvider((Serializer)valueSerializer, (Serializer)keySerializer, genericRecordDataDeserializer, (KafkaAvroSerdeProperties)serdeProperties);
    }

    private GlueKafkaAvroSerdeProperties kafkaAvroSerdeProperties(KafkaProperties kafkaProperties, GlueProperties glueProperties, AwsCredentialsProvider glueAwsCredentialsProvider, JeapKafkaAvroSerdeCryptoConfig cryptoConfig, SignatureAuthenticityService signatureAuthenticityService) {
        return new GlueKafkaAvroSerdeProperties(kafkaProperties, glueProperties, glueAwsCredentialsProvider, cryptoConfig, signatureAuthenticityService);
    }

    private GlueAuthProvider glueAuthProvider(AwsCredentialsProvider awsCredentialsProvider, GlueProperties glueProperties) {
        if (glueProperties.useAssumeRoleForAuth()) {
            String sessionName = this.environment.getProperty("spring.application.name");
            return new GlueAssumeRoleAuthProvider(awsCredentialsProvider, glueProperties, sessionName);
        }
        return () -> awsCredentialsProvider;
    }

    private static Deserializer<GenericData.Record> createGenericRecordDataDeserializer(String clusterName, AwsCredentialsProvider glueCredentialsProvider, GlueKafkaAvroSerdeProperties serdeProperties) {
        JeapGlueAvroDeserializer genericDataRecordDeserializer = new JeapGlueAvroDeserializer(glueCredentialsProvider, null);
        HashMap<String, Object> props = new HashMap<String, Object>(serdeProperties.avroDeserializerProperties(clusterName));
        props.put("avroRecordType", AvroRecordType.GENERIC_RECORD.getName());
        props.remove("jeapSignatureAuthenticityService");
        genericDataRecordDeserializer.configure(props, false);
        return genericDataRecordDeserializer;
    }
}

