/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue;

import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.serde.SerdeUtils;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureService;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistryKafkaSerializer;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class JeapGlueAvroSerializer
implements Serializer<Object> {
    private final GlueSchemaRegistryKafkaSerializer delegate;
    private final JeapKafkaAvroSerdeCryptoConfig cryptoConfig;
    private final SignatureService signatureService;
    private boolean isKey;

    public JeapGlueAvroSerializer(AwsCredentialsProvider awsCredentialsProvider, JeapKafkaAvroSerdeCryptoConfig cryptoConfig, @Nullable SignatureService signatureService) {
        this.delegate = new GlueSchemaRegistryKafkaSerializer(awsCredentialsProvider, null);
        this.cryptoConfig = cryptoConfig;
        this.signatureService = signatureService;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegate.configure(configs, isKey);
        this.isKey = isKey;
    }

    public byte[] serialize(String topic, Object data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, Headers headers, Object record) {
        if (record == null) {
            return null;
        }
        byte[] payload = this.delegate.serialize(topic, headers, record);
        if (this.signatureService != null && headers != null) {
            this.signatureService.injectSignature(headers, payload, this.isKey);
        }
        return SerdeUtils.encryptPayloadIfRequired((boolean)this.isKey, (JeapKafkaAvroSerdeCryptoConfig)this.cryptoConfig, (Headers)headers, (Object)record, (byte[])payload);
    }

    public void close() {
        this.delegate.close();
    }
}

