/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue;

import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapCustomAvroDeserializer;
import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;

public class JeapGlueSchemaRegistryDeserializationFacade
extends GlueSchemaRegistryDeserializationFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapGlueSchemaRegistryDeserializationFacade.class);
    private final Class<?> specificClass;
    private final JeapCustomAvroDeserializer jeapCustomAvroDeserializer = new JeapCustomAvroDeserializer();
    private final LoadingCache<UUID, com.amazonaws.services.schemaregistry.common.Schema> schemaCache;
    private final AWSSchemaRegistryClient schemaRegistryClient;
    private static final GlueSchemaRegistryDeserializerDataParser DESERIALIZER_DATA_PARSER = GlueSchemaRegistryDeserializerDataParser.getInstance();

    public JeapGlueSchemaRegistryDeserializationFacade(@NonNull GlueSchemaRegistryConfiguration configuration, @NonNull AwsCredentialsProvider credentialsProvider, @NonNull Class<?> specificClass) {
        super(configuration, credentialsProvider);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (credentialsProvider == null) {
            throw new NullPointerException("credentialsProvider is marked non-null but is null");
        }
        if (specificClass == null) {
            throw new NullPointerException("specificClass is marked non-null but is null");
        }
        this.specificClass = specificClass;
        this.schemaRegistryClient = super.getSchemaRegistryClient();
        this.schemaCache = this.initializeSchemaCache();
    }

    public Object deserialize(@NonNull AWSDeserializerInput deserializerInput) {
        if (deserializerInput == null) {
            throw new NullPointerException("deserializerInput is marked non-null but is null");
        }
        ByteBuffer buffer = deserializerInput.getBuffer();
        UUID schemaVersionId = DESERIALIZER_DATA_PARSER.getSchemaVersionId(buffer);
        com.amazonaws.services.schemaregistry.common.Schema writerSchema = this.retrieveWriterSchemaRegistrySchema(schemaVersionId);
        return this.jeapCustomAvroDeserializer.deserialize(buffer, writerSchema, this.retrieveReaderSchemaFromSpecificClass());
    }

    private Schema retrieveReaderSchemaFromSpecificClass() {
        try {
            return ((SpecificRecord)this.specificClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSchema();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Unable to retrieve reader schema from specific class {}", (Object)this.specificClass.getName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private com.amazonaws.services.schemaregistry.common.Schema retrieveWriterSchemaRegistrySchema(UUID schemaVersionId) {
        try {
            return (com.amazonaws.services.schemaregistry.common.Schema)this.schemaCache.get((Object)schemaVersionId);
        }
        catch (Exception e) {
            log.error("Unable to retrieve writer schema with uuid {}", (Object)schemaVersionId, (Object)e);
            throw new AWSSchemaRegistryException(e.getCause());
        }
    }

    private LoadingCache<UUID, com.amazonaws.services.schemaregistry.common.Schema> initializeSchemaCache() {
        return CacheBuilder.newBuilder().maximumSize((long)super.getGlueSchemaRegistryConfiguration().getCacheSize()).refreshAfterWrite(super.getGlueSchemaRegistryConfiguration().getTimeToLiveMillis(), TimeUnit.MILLISECONDS).build((CacheLoader)new GlueSchemaRegistryDeserializationCacheLoader());
    }

    private class GlueSchemaRegistryDeserializationCacheLoader
    extends CacheLoader<UUID, com.amazonaws.services.schemaregistry.common.Schema> {
        private GlueSchemaRegistryDeserializationCacheLoader() {
        }

        public com.amazonaws.services.schemaregistry.common.Schema load(UUID schemaVersionId) {
            GetSchemaVersionResponse response = JeapGlueSchemaRegistryDeserializationFacade.this.schemaRegistryClient.getSchemaVersionResponse(schemaVersionId.toString());
            return new com.amazonaws.services.schemaregistry.common.Schema(response.schemaDefinition(), response.dataFormat().name(), this.getSchemaName(response.schemaArn()));
        }

        private String getSchemaName(String schemaArn) {
            Arn arn = Arn.fromString((String)schemaArn);
            String resource = arn.resourceAsString();
            String[] splitArray = resource.split("/");
            return splitArray[splitArray.length - 1];
        }
    }
}

