/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue.config.auth;

import ch.admin.bit.jeap.messaging.kafka.properties.cluster.GlueProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.config.auth.GlueAuthProvider;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class GlueAssumeRoleAuthProvider
implements GlueAuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueAssumeRoleAuthProvider.class);
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final GlueProperties properties;
    private final String sessionName;

    public GlueAssumeRoleAuthProvider(AwsCredentialsProvider awsCredentialsProvider, GlueProperties properties, String sessionName) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.properties = properties;
        this.sessionName = sessionName;
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider() {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(Region.of((String)this.properties.getRegion()));
        if (this.properties.getStsEndpoint() != null) {
            stsClientBuilder.endpointOverride(this.properties.getStsEndpoint());
        }
        log.info("Building STS client with properties region={}, endpointOverride={}, timeout={}, assumeRolArn={}, sessionName={}", new Object[]{this.properties.getRegion(), this.properties.getStsEndpoint(), this.properties.getStsClientTimeoutSeconds(), this.properties.getAssumeIamRoleArn(), this.sessionName});
        StsClient stsClient = (StsClient)((StsClientBuilder)stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder().connectionTimeout(Duration.ofSeconds(this.properties.getStsClientTimeoutSeconds())).socketTimeout(Duration.ofSeconds(this.properties.getStsClientTimeoutSeconds())))).build();
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(() -> {
            log.debug("Refreshing STS credentials");
            return (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.properties.getAssumeIamRoleArn()).roleSessionName(this.sessionName).build();
        }).build();
    }
}

