/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue;

import ch.admin.bit.jeap.messaging.kafka.serde.glue.DatumReaderCacheKey;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapCustomDatumReaderFactory;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeapCustomAvroDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapCustomAvroDeserializer.class);
    private static final AVROUtils AVRO_UTILS = AVROUtils.getInstance();
    private static final GlueSchemaRegistryDeserializerDataParser DESERIALIZER_DATA_PARSER = GlueSchemaRegistryDeserializerDataParser.getInstance();
    private static final long MAX_DATUM_READER_CACHE_SIZE = 100L;
    @NonNull
    protected final LoadingCache<DatumReaderCacheKey, DatumReader<Object>> datumReaderCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new DatumReaderCache());

    public Object deserialize(@NonNull ByteBuffer buffer, com.amazonaws.services.schemaregistry.common.Schema schema, Schema readerSchema) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        try {
            byte[] data = DESERIALIZER_DATA_PARSER.getPlainData(buffer);
            log.debug("Length of actual message: {}", (Object)data.length);
            Schema writerSchema = AVRO_UTILS.parseSchema(schema.getSchemaDefinition());
            DatumReader datumReader = (DatumReader)this.datumReaderCache.get((Object)new DatumReaderCacheKey(writerSchema, readerSchema));
            BinaryDecoder binaryDecoder = this.getBinaryDecoder(data, data.length);
            Object result = datumReader.read(null, (Decoder)binaryDecoder);
            log.debug("Finished de-serializing Avro message");
            return result;
        }
        catch (IOException | ExecutionException e) {
            log.error("Unable to deserialize message with writer schema {} and reader schema {}", new Object[]{schema.getSchemaName(), readerSchema.getName(), e});
            throw new RuntimeException(e);
        }
    }

    private BinaryDecoder getBinaryDecoder(byte[] data, int end) {
        return DecoderFactory.get().binaryDecoder(data, 0, end, null);
    }

    @Generated
    public static JeapCustomAvroDeserializerBuilder builder() {
        return new JeapCustomAvroDeserializerBuilder();
    }

    @NonNull
    @Generated
    public LoadingCache<DatumReaderCacheKey, DatumReader<Object>> getDatumReaderCache() {
        return this.datumReaderCache;
    }

    private static class DatumReaderCache
    extends CacheLoader<DatumReaderCacheKey, DatumReader<Object>> {
        private DatumReaderCache() {
        }

        public DatumReader<Object> load(DatumReaderCacheKey key) throws Exception {
            return JeapCustomDatumReaderFactory.from(key.writer(), key.reader());
        }
    }

    @Generated
    public static class JeapCustomAvroDeserializerBuilder {
        @Generated
        JeapCustomAvroDeserializerBuilder() {
        }

        @Generated
        public JeapCustomAvroDeserializer build() {
            return new JeapCustomAvroDeserializer();
        }

        @Generated
        public String toString() {
            return "JeapCustomAvroDeserializer.JeapCustomAvroDeserializerBuilder()";
        }
    }
}

