/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue;

import ch.admin.bit.jeap.kafka.SerializedMessageReceiver;
import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.serde.SerdeUtils;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueSchemaRegistryDeserializationFacade;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureAuthenticityService;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryKafkaDeserializer;
import jakarta.annotation.Nullable;
import java.util.Map;
import lombok.Generated;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class JeapGlueAvroDeserializer
implements Deserializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapGlueAvroDeserializer.class);
    public static final String SPECIFIC_AVRO_KEY_TYPE = "specific.avro.key.type";
    public static final String SPECIFIC_AVRO_VALUE_TYPE = "specific.avro.value.type";
    private GlueSchemaRegistryKafkaDeserializer delegate;
    private SignatureAuthenticityService signatureAuthenticityService;
    private JeapKafkaAvroSerdeCryptoConfig cryptoConfig;
    private boolean isKey;

    public JeapGlueAvroDeserializer() {
        this(null, null);
    }

    public JeapGlueAvroDeserializer(AwsCredentialsProvider awsCredentialsProvider, @Nullable SignatureAuthenticityService signatureAuthenticityService) {
        this.delegate = new GlueSchemaRegistryKafkaDeserializer(awsCredentialsProvider, null);
        this.signatureAuthenticityService = signatureAuthenticityService;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.addCredentialsProviderIfMissing(configs);
        this.addCryptoConfig(configs);
        this.setSignatureAuthenticityService(configs);
        this.defineSpecificDeserializerIfSpecificClassIsConfigured(configs, isKey);
        this.delegate.configure(configs, isKey);
        this.isKey = isKey;
    }

    private void addCredentialsProviderIfMissing(Map<String, ?> configs) {
        if (this.delegate.getCredentialProvider() == null) {
            log.debug("Add missing credentialsProvider to GlueSchemaRegistryKafkaDeserializer");
            AwsCredentialsProvider awsCredentialsProvider = (AwsCredentialsProvider)configs.get("glueAwsCredentialsProvider");
            this.delegate = new GlueSchemaRegistryKafkaDeserializer(awsCredentialsProvider, null);
        }
    }

    private void addCryptoConfig(Map<String, ?> configs) {
        if (configs.get("jeapKafkaAvroSerdeCryptoConfig") != null) {
            this.cryptoConfig = (JeapKafkaAvroSerdeCryptoConfig)configs.get("jeapKafkaAvroSerdeCryptoConfig");
        }
    }

    private void setSignatureAuthenticityService(Map<String, ?> configs) {
        if (configs.get("jeapSignatureAuthenticityService") != null) {
            this.signatureAuthenticityService = (SignatureAuthenticityService)configs.get("jeapSignatureAuthenticityService");
        }
    }

    private void defineSpecificDeserializerIfSpecificClassIsConfigured(Map<String, ?> configs, boolean isKey) {
        if (configs.containsKey(this.getSpecificAvroKeyFromType(isKey))) {
            Class<?> specificAvroTypeClass;
            String specificAvroType = (String)configs.get(this.getSpecificAvroKeyFromType(isKey));
            log.info("Configuring specific avro specificAvroType {}", (Object)specificAvroType);
            try {
                specificAvroTypeClass = Class.forName(specificAvroType);
            }
            catch (ClassNotFoundException e) {
                log.error("Unable to instantiate class from type {}", (Object)specificAvroType, (Object)e);
                throw new RuntimeException(e);
            }
            GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
            glueSchemaRegistryConfiguration.setUserAgentApp("kafka");
            JeapGlueSchemaRegistryDeserializationFacade facade = new JeapGlueSchemaRegistryDeserializationFacade(glueSchemaRegistryConfiguration, this.delegate.getCredentialProvider(), specificAvroTypeClass);
            this.delegate.setGlueSchemaRegistryDeserializationFacade((GlueSchemaRegistryDeserializationFacade)facade);
        }
    }

    private String getSpecificAvroKeyFromType(boolean isKey) {
        if (isKey) {
            return SPECIFIC_AVRO_KEY_TYPE;
        }
        return SPECIFIC_AVRO_VALUE_TYPE;
    }

    public Object deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public Object deserialize(String topic, Headers headers, byte[] originalBytes) {
        byte[] possiblyDecryptedBytes = SerdeUtils.decryptIfEncrypted((boolean)this.isKey, (JeapKafkaAvroSerdeCryptoConfig)this.cryptoConfig, (String)topic, (byte[])originalBytes, (Headers)headers);
        Object result = this.delegate.deserialize(topic, headers, possiblyDecryptedBytes);
        if (result instanceof SerializedMessageReceiver) {
            SerializedMessageReceiver smr = (SerializedMessageReceiver)result;
            smr.setSerializedMessage(originalBytes);
        }
        if (this.signatureAuthenticityService != null) {
            if (this.isKey) {
                this.signatureAuthenticityService.checkAuthenticityKey(headers, possiblyDecryptedBytes);
            } else {
                this.signatureAuthenticityService.checkAuthenticityValue(result, headers, possiblyDecryptedBytes);
            }
        }
        return result;
    }

    public void close() {
        this.delegate.close();
    }
}

