/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue.config;

import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.AwsProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.ClusterProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.config.GlueSchemaRegistryBeanRegistrar;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

@AutoConfiguration
@Import(value={GlueSchemaRegistryBeanRegistrar.class})
public class GlueAutoConfiguration {
    @Bean
    @Conditional(value={GlueActiveForAnyClusterCondition.class})
    @ConditionalOnMissingBean(value={AwsCredentialsProvider.class})
    DefaultCredentialsProvider awsCredentialsProvider() {
        return DefaultCredentialsProvider.create();
    }

    public static class GlueActiveForAnyClusterCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            KafkaProperties kafkaProperties = JeapKafkaPropertyFactory.createJeapKafkaProperties((Environment)context.getEnvironment());
            return kafkaProperties.clusterNames().stream().anyMatch(clusterName -> GlueActiveForAnyClusterCondition.isGlueActive(clusterName, kafkaProperties));
        }

        private static boolean isGlueActive(String clusterName, KafkaProperties kafkaProperties) {
            AwsProperties aws = ((ClusterProperties)kafkaProperties.clusterProperties(clusterName).orElseThrow()).getAws();
            return aws != null && aws.getGlue() != null && aws.getGlue().isActive();
        }
    }
}

