/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.serde.glue.config.properties;

import ch.admin.bit.jeap.messaging.kafka.crypto.JeapKafkaAvroSerdeCryptoConfig;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.cluster.GlueProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.EmptyKeyDeserializer;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProperties;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueAvroDeserializer;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.JeapGlueAvroSerializer;
import ch.admin.bit.jeap.messaging.kafka.serde.glue.naming.GlueTopicRecordSchemaNamingStrategy;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureAuthenticityService;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.Compatibility;

public class GlueKafkaAvroSerdeProperties
implements KafkaAvroSerdeProperties {
    public static final String GLUE_AWS_CREDENTIALS_PROVIDER = "glueAwsCredentialsProvider";
    public static final String JEAP_CRYPTO_CONFIG = "jeapKafkaAvroSerdeCryptoConfig";
    public static final String JEAP_SIGNATURE_AUTHENTICITY_SERVICE = "jeapSignatureAuthenticityService";
    private final KafkaProperties kafkaProperties;
    private final GlueProperties configProperties;
    private final AwsCredentialsProvider glueAwsCredentialsProvider;
    private final JeapKafkaAvroSerdeCryptoConfig cryptoConfig;
    private final SignatureAuthenticityService signatureAuthenticityService;

    public GlueKafkaAvroSerdeProperties(KafkaProperties kafkaProperties, GlueProperties configProperties, AwsCredentialsProvider glueAwsCredentialsProvider, JeapKafkaAvroSerdeCryptoConfig cryptoConfig, SignatureAuthenticityService signatureAuthenticityService) {
        this.kafkaProperties = kafkaProperties;
        this.configProperties = configProperties;
        this.glueAwsCredentialsProvider = glueAwsCredentialsProvider;
        this.cryptoConfig = cryptoConfig;
        this.signatureAuthenticityService = signatureAuthenticityService;
    }

    public Map<String, Object> avroSerializerProperties(String clusterName) {
        this.validateSerializerProperties();
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.addCommonProps(props);
        String registryName = this.configProperties.getRegistryName();
        props.put("key.serializer", JeapGlueAvroSerializer.class.getName());
        props.put("value.serializer", JeapGlueAvroSerializer.class.getName());
        props.put("dataFormat", "AVRO");
        Map<String, String> metadata = this.createMetadata();
        props.put("metadata", metadata);
        props.put("description", this.getRegistryDescription(registryName));
        props.put("compression", AWSSchemaRegistryConstants.COMPRESSION.NONE.name());
        props.put("schemaNameGenerationClass", GlueTopicRecordSchemaNamingStrategy.class.getName());
        props.put("compatibility", Compatibility.NONE);
        props.put("schemaAutoRegistrationEnabled", this.kafkaProperties.isAutoRegisterSchema());
        props.put("registry.name", registryName);
        return props;
    }

    public Map<String, Object> avroDeserializerProperties(String clusterName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.addCommonProps(props);
        props.put("avroRecordType", AvroRecordType.SPECIFIC_RECORD.getName());
        props.put("spring.deserializer.value.delegate.class", JeapGlueAvroDeserializer.class);
        props.put(GLUE_AWS_CREDENTIALS_PROVIDER, this.glueAwsCredentialsProvider);
        if (this.cryptoConfig != null) {
            props.put(JEAP_CRYPTO_CONFIG, this.cryptoConfig);
        }
        if (this.signatureAuthenticityService != null) {
            props.put(JEAP_SIGNATURE_AUTHENTICITY_SERVICE, this.signatureAuthenticityService);
        }
        if (this.kafkaProperties.isExposeMessageKeyToConsumer()) {
            props.put("spring.deserializer.key.delegate.class", JeapGlueAvroDeserializer.class);
        } else {
            props.put("spring.deserializer.key.delegate.class", EmptyKeyDeserializer.class);
        }
        return props;
    }

    private void addCommonProps(Map<String, Object> props) {
        String awsRegion = this.configProperties.getRegion();
        URI glueEndpoint = this.configProperties.getEndpoint();
        props.put("cacheSize", "200");
        props.put("timeToLiveMillis", "86400000");
        props.put("region", awsRegion);
        if (glueEndpoint != null) {
            props.put("endpoint", glueEndpoint.toString());
        }
    }

    private Map<String, String> createMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("registered-by-service", this.kafkaProperties.getServiceName());
        metadata.put("registered-by-system", this.kafkaProperties.getSystemName());
        return metadata;
    }

    private String getRegistryDescription(String registryName) {
        return registryName + " " + this.kafkaProperties.getServiceName();
    }

    private void validateSerializerProperties() {
        this.validatePropertyHasValue("systemName", this.kafkaProperties.getSystemName());
        this.validatePropertyHasValue("serviceName", this.kafkaProperties.getServiceName());
    }

    private void validatePropertyHasValue(String propertyName, String value) {
        if (value == null || value.isBlank()) {
            throw new IllegalStateException("Property jeap.messaging.kafka.%s is missing a valid value. This property needs to be set for applications using a glue schema registry.".formatted(propertyName));
        }
    }
}

