/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing;

import ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing.IdempotentProcessingConfig;
import ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing.IdempotentProcessingRepository;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdempotentProcessingHouseKeeping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdempotentProcessingHouseKeeping.class);
    private final IdempotentProcessingRepository idempotentProcessingRepository;
    private final IdempotentProcessingConfig config;

    public void deleteOldIdempotentProcessingRecords() {
        log.info("House keeping: deleting old idempotent processing records..");
        ZonedDateTime deleteBefore = ZonedDateTime.now().minus(this.config.getIdempotentProcessingRetentionDuration());
        int deleted = this.idempotentProcessingRepository.deleteAllCreatedBefore(deleteBefore);
        log.info("House keeping: ..done. Deleted {} old idempotent processing records.", (Object)deleted);
    }

    @Generated
    public IdempotentProcessingHouseKeeping(IdempotentProcessingRepository idempotentProcessingRepository, IdempotentProcessingConfig config) {
        this.idempotentProcessingRepository = idempotentProcessingRepository;
        this.config = config;
    }
}

