/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embeddable
public class IdempotentProcessingIdentity
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdempotentProcessingIdentity.class);
    private static final Pattern MESSAGE_CONTEXT_PATTERN = Pattern.compile("^(.*)(V[0-9]+)(Event|Command)");
    @Column(name="idempotence_id")
    private String id;
    @Column(name="idempotence_id_context")
    private String context;

    public static IdempotentProcessingIdentity from(String id, String context) {
        Objects.requireNonNull(id, "Idempotence id must not be null.");
        Objects.requireNonNull(id, "Idempotence id context must not be null.");
        return new IdempotentProcessingIdentity(id, IdempotentProcessingIdentity.removeVersionFromContext(context));
    }

    private static String removeVersionFromContext(String context) {
        Matcher matcher = MESSAGE_CONTEXT_PATTERN.matcher(context);
        if (matcher.find()) {
            String contextWithoutVersion = matcher.group(1) + matcher.group(3);
            log.debug("Found version in message context '{}'. Returning context without version '{}'...", (Object)matcher.group(0), (Object)contextWithoutVersion);
            return contextWithoutVersion;
        }
        return context;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public String toString() {
        return "IdempotentProcessingIdentity(id=" + this.getId() + ", context=" + this.getContext() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdempotentProcessingIdentity)) {
            return false;
        }
        IdempotentProcessingIdentity other = (IdempotentProcessingIdentity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdempotentProcessingIdentity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    @Generated
    private IdempotentProcessingIdentity(String id, String context) {
        this.id = id;
        this.context = context;
    }

    @Generated
    protected IdempotentProcessingIdentity() {
    }
}

