/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.idempotence.messagehandler;

import ch.admin.bit.jeap.messaging.idempotence.messagehandler.IdempotentMessageHandlerConfig;
import ch.admin.bit.jeap.messaging.idempotence.messagehandler.IdempotentMessageHandlerExecutionSkippedException;
import ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing.IdempotentProcessingIdentity;
import ch.admin.bit.jeap.messaging.idempotence.processing.idempotentprocessing.IdempotentProcessingRepository;
import ch.admin.bit.jeap.messaging.model.Message;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
@Component
public class IdempotentMessageHandlerAspect
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdempotentMessageHandlerAspect.class);
    private final IdempotentProcessingRepository idempotentProcessingRepository;
    private final IdempotentMessageHandlerConfig config;

    @Around(value="@annotation(IdempotentMessageHandler) && args(message,..)")
    public Object handleIdempotence(ProceedingJoinPoint joinPoint, Message message) throws Throwable {
        this.assertTransactionActive();
        String idempotenceId = message.getIdentity().getIdempotenceId();
        String idempotenceIdContext = message.getType().getName();
        IdempotentProcessingIdentity id = IdempotentProcessingIdentity.from(idempotenceId, idempotenceIdContext);
        log.debug("Checking for existing idempotent processing for {}.", (Object)id);
        if (this.createIdempotentProcessing(id)) {
            log.debug("No existing idempotent processing found for {}. Proceeding to processing.", (Object)id);
            return joinPoint.proceed();
        }
        log.debug("Existing idempotent processing found for {}. Skipping processing.", (Object)id);
        return null;
    }

    private boolean createIdempotentProcessing(IdempotentProcessingIdentity idempotentProcessingIdentity) {
        try {
            return this.idempotentProcessingRepository.createIfNotExists(idempotentProcessingIdentity);
        }
        catch (DataIntegrityViolationException | PessimisticLockingFailureException e) {
            throw IdempotentMessageHandlerExecutionSkippedException.concurrentHandlingIdempotentProcessingException(idempotentProcessingIdentity, e);
        }
        catch (Exception e) {
            throw IdempotentMessageHandlerExecutionSkippedException.generalIdempotentProcessingException(idempotentProcessingIdentity, e);
        }
    }

    public int getOrder() {
        return this.config.getAdviceOrder();
    }

    private void assertTransactionActive() {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("Automatic idempotent message handling requires an active transaction!");
        }
    }

    @Generated
    public IdempotentMessageHandlerAspect(IdempotentProcessingRepository idempotentProcessingRepository, IdempotentMessageHandlerConfig config) {
        this.idempotentProcessingRepository = idempotentProcessingRepository;
        this.config = config;
    }
}

