/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.bean;

import ch.admin.bit.jeap.messaging.kafka.KafkaConfiguration;
import ch.admin.bit.jeap.messaging.kafka.interceptor.CallbackRecordInterceptor;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProvider;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.tracing.JeapKafkaTracing;
import ch.admin.bit.jeap.messaging.kafka.tracing.TracerBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.kafka.ConcurrentKafkaListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.ContainerCustomizer;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.CompositeRecordInterceptor;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.transaction.KafkaTransactionManager;

class JeapKafkaBeanDefinitionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapKafkaBeanDefinitionFactory.class);
    private final BeanFactory beanFactory;
    private final KafkaProperties springKafkaProperties;
    private final JeapKafkaBeanNames jeapKafkaBeanNames;
    private final String defaultProducerClusterOverride;

    GenericBeanDefinition createListenerContainerFactory(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ConcurrentKafkaListenerContainerFactory.class);
        beanDefinition.setInstanceSupplier(() -> {
            ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
            String consumerFactoryBeanName = this.jeapKafkaBeanNames.getConsumerFactoryBeanName(clusterName);
            ConsumerFactory kafkaConsumerFactory = (ConsumerFactory)this.beanFactory.getBean(consumerFactoryBeanName);
            String kafkaTemplateBeanName = this.jeapKafkaBeanNames.getKafkaTemplateBeanName(clusterName);
            KafkaTemplate kafkaTemplate = (KafkaTemplate)this.beanFactory.getBean(kafkaTemplateBeanName);
            String kafkaAdminBeanName = this.jeapKafkaBeanNames.getAdminBeanName(clusterName);
            KafkaAdmin kafkaAdmin = (KafkaAdmin)this.beanFactory.getBean(kafkaAdminBeanName);
            ConcurrentKafkaListenerContainerFactoryConfigurer configurer = (ConcurrentKafkaListenerContainerFactoryConfigurer)this.beanFactory.getBean("kafkaListenerContainerFactoryConfigurer");
            configurer.configure(factory, kafkaConsumerFactory);
            this.setRecordInterceptors((ConcurrentKafkaListenerContainerFactory<Object, Object>)factory);
            factory.setReplyTemplate(kafkaTemplate);
            ObjectProvider kafkaTransactionManager = this.beanFactory.getBeanProvider(KafkaTransactionManager.class);
            kafkaTransactionManager.ifAvailable(arg_0 -> ((ContainerProperties)factory.getContainerProperties()).setKafkaAwareTransactionManager(arg_0));
            ObjectProvider containerCustomizer = this.beanFactory.getBeanProvider(ContainerCustomizer.class);
            factory.setContainerCustomizer(container -> {
                containerCustomizer.ifAvailable(c -> c.configure(container));
                container.setKafkaAdmin(kafkaAdmin);
            });
            ObjectProvider tracerBridge = this.beanFactory.getBeanProvider(TracerBridge.class);
            tracerBridge.ifAvailable(bean -> {
                log.debug("Kafka tracing is active: enable observation on kafkaTemplate and kafkaListenerContainerFactory...");
                factory.getContainerProperties().setObservationEnabled(true);
                kafkaTemplate.setObservationEnabled(true);
            });
            return factory;
        });
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.jeapKafkaBeanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    private void setRecordInterceptors(ConcurrentKafkaListenerContainerFactory<Object, Object> factory) {
        int count;
        List recordInterceptorsFromContext = this.beanFactory.getBeanProvider(RecordInterceptor.class).stream().toList();
        ArrayList<RecordInterceptor> recordInterceptors = new ArrayList<RecordInterceptor>(recordInterceptorsFromContext);
        List<JeapKafkaMessageCallback> callbacks = this.beanFactory.getBeanProvider(JeapKafkaMessageCallback.class).stream().toList();
        if (!callbacks.isEmpty()) {
            recordInterceptors.add(new CallbackRecordInterceptor(callbacks));
        }
        if ((count = recordInterceptors.size()) == 1) {
            factory.setRecordInterceptor((RecordInterceptor)recordInterceptors.getFirst());
        } else if (count > 1) {
            factory.setRecordInterceptor((RecordInterceptor)new CompositeRecordInterceptor(recordInterceptors.toArray(new RecordInterceptor[0])));
        }
    }

    GenericBeanDefinition createKafkaAdmin(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(KafkaAdmin.class);
        beanDefinition.setInstanceSupplier(() -> {
            HashMap<String, Object> configs = new HashMap<String, Object>(this.springKafkaProperties.buildAdminProperties(null));
            KafkaConfiguration jeapKafkaConfiguration = (KafkaConfiguration)this.beanFactory.getBean(KafkaConfiguration.class);
            configs.putAll(jeapKafkaConfiguration.adminConfig(clusterName));
            KafkaAdmin kafkaAdmin = new KafkaAdmin(configs);
            kafkaAdmin.setFatalIfBrokerNotAvailable(this.springKafkaProperties.getAdmin().isFailFast());
            return kafkaAdmin;
        });
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.jeapKafkaBeanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createKafkaProducerFactory(String clusterName) {
        Map properties = this.springKafkaProperties.buildProducerProperties(null);
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DefaultKafkaProducerFactory.class);
        beanDefinition.setInstanceSupplier(() -> {
            DefaultKafkaProducerFactory factory = new DefaultKafkaProducerFactory(properties);
            String transactionIdPrefix = this.springKafkaProperties.getProducer().getTransactionIdPrefix();
            if (transactionIdPrefix != null) {
                factory.setTransactionIdPrefix(transactionIdPrefix);
            }
            KafkaAvroSerdeProvider kafkaAvroSerdeProvider = (KafkaAvroSerdeProvider)this.beanFactory.getBean(this.jeapKafkaBeanNames.getKafkaAvroSerdeProviderBeanName(clusterName));
            factory.setValueSerializer(kafkaAvroSerdeProvider.getValueSerializer());
            factory.setKeySerializer(kafkaAvroSerdeProvider.getKeySerializer());
            KafkaConfiguration jeapKafkaConfiguration = (KafkaConfiguration)this.beanFactory.getBean(KafkaConfiguration.class);
            factory.updateConfigs(jeapKafkaConfiguration.producerConfig(clusterName));
            return factory;
        });
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.isPrimaryProducerCluster(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createTransactionManager(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(KafkaTransactionManager.class);
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        String producerFactoryBeanName = this.jeapKafkaBeanNames.getProducerFactoryBeanName(clusterName);
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(producerFactoryBeanName));
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.jeapKafkaBeanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createKafkaConsumerFactory(String clusterName) {
        Map properties = this.springKafkaProperties.buildConsumerProperties(null);
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DefaultKafkaConsumerFactory.class);
        beanDefinition.setInstanceSupplier(() -> {
            DefaultKafkaConsumerFactory factory = new DefaultKafkaConsumerFactory(properties);
            ObjectProvider jeapKafkaTracingProvider = this.beanFactory.getBeanProvider(JeapKafkaTracing.class);
            jeapKafkaTracingProvider.ifAvailable(jeapKafkaTracing -> factory.addPostProcessor(arg_0 -> ((JeapKafkaTracing)jeapKafkaTracing).consumer(arg_0)));
            KafkaConfiguration jeapKafkaConfiguration = (KafkaConfiguration)this.beanFactory.getBean(KafkaConfiguration.class);
            factory.updateConfigs(jeapKafkaConfiguration.consumerConfig(clusterName));
            return factory;
        });
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.jeapKafkaBeanNames.isPrimaryBean(clusterName));
        return beanDefinition;
    }

    GenericBeanDefinition createKafkaTemplate(String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(KafkaTemplate.class);
        beanDefinition.setAutowireMode(3);
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        String producerFactoryBeanName = this.jeapKafkaBeanNames.getProducerFactoryBeanName(clusterName);
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(producerFactoryBeanName));
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.addPropertyValue("defaultTopic", (Object)this.springKafkaProperties.getTemplate().getDefaultTopic());
        propertyValues.addPropertyValue("transactionIdPrefix", (Object)this.springKafkaProperties.getTemplate().getTransactionIdPrefix());
        propertyValues.addPropertyValue("producerListener", (Object)new RuntimeBeanReference(ProducerListener.class));
        String adminBeanName = this.jeapKafkaBeanNames.getAdminBeanName(clusterName);
        propertyValues.addPropertyValue("kafkaAdmin", (Object)new RuntimeBeanReference(adminBeanName));
        this.setRecordMessageConverterIfSingleCandidateBeanReference(propertyValues);
        beanDefinition.setPropertyValues(propertyValues);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setPrimary(this.isPrimaryProducerCluster(clusterName));
        return beanDefinition;
    }

    private void setRecordMessageConverterIfSingleCandidateBeanReference(MutablePropertyValues propertyValues) {
        ListableBeanFactory listableBeanFactory;
        String[] beanNamesForType;
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ListableBeanFactory && (beanNamesForType = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)(listableBeanFactory = (ListableBeanFactory)beanFactory), RecordMessageConverter.class, (boolean)false, (boolean)false)).length == 1) {
            propertyValues.addPropertyValue("recordMessageConverter", (Object)new RuntimeBeanReference(beanNamesForType[0]));
        }
    }

    private boolean isPrimaryProducerCluster(String clusterName) {
        return this.jeapKafkaBeanNames.isPrimaryProducerCluster(this.defaultProducerClusterOverride, clusterName);
    }

    @Generated
    public JeapKafkaBeanDefinitionFactory(BeanFactory beanFactory, KafkaProperties springKafkaProperties, JeapKafkaBeanNames jeapKafkaBeanNames, String defaultProducerClusterOverride) {
        this.beanFactory = beanFactory;
        this.springKafkaProperties = springKafkaProperties;
        this.jeapKafkaBeanNames = jeapKafkaBeanNames;
        this.defaultProducerClusterOverride = defaultProducerClusterOverride;
    }
}

