/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.interceptor;

import ch.admin.bit.jeap.messaging.kafka.interceptor.Callbacks;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.model.Message;
import java.util.List;
import lombok.Generated;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.RecordInterceptor;

public class CallbackRecordInterceptor
implements RecordInterceptor<Object, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackRecordInterceptor.class);
    private final List<JeapKafkaMessageCallback> callbacks;

    public CallbackRecordInterceptor(List<JeapKafkaMessageCallback> callbacks) {
        this.callbacks = callbacks;
    }

    public ConsumerRecord<Object, Object> intercept(ConsumerRecord<Object, Object> record, Consumer<Object, Object> consumer) {
        Object object = record.value();
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.callbacks.forEach(cb -> Callbacks.invokeCallback(msg, record.topic(), cb::beforeConsume));
        }
        return record;
    }

    public void success(ConsumerRecord<Object, Object> record, Consumer<Object, Object> consumer) {
        Object object = record.value();
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.callbacks.forEach(cb -> Callbacks.invokeCallback(msg, record.topic(), cb::afterConsume));
        }
    }

    public void afterRecord(ConsumerRecord<Object, Object> record, Consumer<Object, Object> consumer) {
        Object object = record.value();
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.callbacks.forEach(cb -> Callbacks.invokeCallback(msg, record.topic(), cb::afterRecord));
        }
    }
}

