/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka;

import ch.admin.bit.jeap.messaging.kafka.KafkaConsumerConfiguration;
import ch.admin.bit.jeap.messaging.kafka.auth.KafkaAuthProperties;
import ch.admin.bit.jeap.messaging.kafka.bean.JeapKafkaBeanRegistrar;
import ch.admin.bit.jeap.messaging.kafka.contract.ConsumerContractInterceptor;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsValidator;
import ch.admin.bit.jeap.messaging.kafka.contract.ProducerContractInterceptor;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ClusterNameHeaderInterceptor;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.CreateSerializedMessageHolder;
import ch.admin.bit.jeap.messaging.kafka.interceptor.CallbackInterceptor;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.kafka.log.ConsumerLoggingInterceptor;
import ch.admin.bit.jeap.messaging.kafka.log.ProducerLoggerInterceptor;
import ch.admin.bit.jeap.messaging.kafka.metrics.ConsumerMetricsInterceptor;
import ch.admin.bit.jeap.messaging.kafka.metrics.KafkaMessagingMetrics;
import ch.admin.bit.jeap.messaging.kafka.metrics.ProducerMetricsInterceptor;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaConsumerPropertiesValidator;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.properties.PropertyRequirements;
import ch.admin.bit.jeap.messaging.kafka.serde.EmptyKeyDeserializer;
import ch.admin.bit.jeap.messaging.kafka.serde.KafkaAvroSerdeProvider;
import ch.admin.bit.jeap.messaging.kafka.signature.publisher.SignaturePublisherProperties;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.tracing.KafkaTracingConfiguration;
import ch.admin.bit.jeap.messaging.kafka.tracing.TracerBridge;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@AutoConfiguration(before={KafkaAutoConfiguration.class, KafkaConsumerConfiguration.class}, after={KafkaTracingConfiguration.class}, afterName={"BraveAutoConfiguration"})
@EnableKafka
@Import(value={JeapKafkaBeanRegistrar.class})
public class KafkaConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaConfiguration.class);
    private final KafkaProperties kafkaProperties;
    private final TracerBridge tracerBridge;
    private final KafkaMessagingMetrics kafkaMessagingMetrics;
    private final ContractsValidator contractsValidator;
    private final BeanFactory beanFactory;
    private final JeapKafkaBeanNames beanNames;
    @Value(value="${spring.application.name}")
    private String applicationName;

    KafkaConfiguration(KafkaProperties kafkaProperties, Optional<TracerBridge> tracerBridge, ContractsValidator contractsValidator, Optional<KafkaMessagingMetrics> kafkaMetrics, BeanFactory beanFactory) {
        this.kafkaProperties = kafkaProperties;
        this.tracerBridge = tracerBridge.orElse(null);
        this.contractsValidator = contractsValidator;
        this.kafkaMessagingMetrics = kafkaMetrics.orElse(null);
        this.beanFactory = beanFactory;
        this.beanNames = new JeapKafkaBeanNames(kafkaProperties.getDefaultClusterName());
    }

    @PostConstruct
    private void printConfig() {
        TreeSet clusterNames = new TreeSet(this.kafkaProperties.clusterNames());
        clusterNames.forEach(clusterName -> log.info("Configuration for Kafka Cluster {}: Schema-Registry: '{}', Autocommit-Schemas: '{}', Consumer-Bootstrap-Server: '{}', Producer-Bootstrap-Server: '{}', Admin-Bootstrap-Server: '{}'", new Object[]{clusterName, this.kafkaProperties.isUseSchemaRegistry() ? this.kafkaProperties.getSchemaRegistryUrl(clusterName) : "None", this.kafkaProperties.isUseSchemaRegistry() ? Boolean.valueOf(this.kafkaProperties.isAutoRegisterSchema()) : "-", String.valueOf(this.kafkaProperties.getSecurityProtocol(clusterName)) + " " + this.kafkaProperties.getConsumerBootstrapServers(clusterName), String.valueOf(this.kafkaProperties.getSecurityProtocol(clusterName)) + " " + this.kafkaProperties.getProducerBootstrapServers(clusterName), String.valueOf(this.kafkaProperties.getSecurityProtocol(clusterName)) + " " + this.kafkaProperties.getAdminClientBootstrapServers(clusterName)}));
    }

    @Bean
    KafkaConsumerPropertiesValidator kafkaConsumerPropertiesValidator(ListenerContainerRegistry listenerContainerRegistry) {
        return new KafkaConsumerPropertiesValidator(listenerContainerRegistry, this.kafkaProperties);
    }

    public Map<String, Object> adminConfig(String clusterName) {
        Map<String, Object> props = this.commonConfig(clusterName);
        props.put("bootstrap.servers", PropertyRequirements.requireNonNullValue((String)"bootstrap.servers for admin clients", (Object)this.kafkaProperties.getAdminClientBootstrapServers(clusterName)));
        return props;
    }

    public Map<String, Object> consumerConfig(String clusterName) {
        ArrayList interceptors = new ArrayList();
        Map<String, Object> props = this.commonConfig(clusterName);
        String consumerBootstrapServers = this.kafkaProperties.getConsumerBootstrapServers(clusterName);
        props.put("bootstrap.servers", PropertyRequirements.requireNonNullValue((String)"bootstrap.servers for consumers", (Object)consumerBootstrapServers));
        KafkaAvroSerdeProvider kafkaAvroSerdeProvider = (KafkaAvroSerdeProvider)this.beanFactory.getBean(this.beanNames.getKafkaAvroSerdeProviderBeanName(clusterName));
        props.putAll(kafkaAvroSerdeProvider.getSerdeProperties().avroDeserializerProperties(clusterName));
        props.put("group.id", this.applicationName);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        props.put("spring.deserializer.value.function", CreateSerializedMessageHolder.class);
        props.put("clusternameheaderinterceptor.clustername", clusterName);
        interceptors.add(ClusterNameHeaderInterceptor.class);
        interceptors.add(ConsumerContractInterceptor.class);
        interceptors.add(ConsumerLoggingInterceptor.class);
        props.put("consumerlogginginterceptor.clustername", clusterName);
        props.put("consumerContractInterceptor.contractsValidator", this.contractsValidator);
        props.put("consumerContractInterceptor.allowNoContractEvents", this.kafkaProperties.isConsumeWithoutContractAllowed());
        props.put("consumerContractInterceptor.silentIgnoreWithoutContract", this.kafkaProperties.isSilentIgnoreWithoutContract());
        if (this.tracerBridge != null) {
            props.put("consumerlogginginterceptor.tracerbridge", this.tracerBridge);
        }
        if (this.kafkaProperties.isExposeMessageKeyToConsumer()) {
            props.put("key.deserializer", ErrorHandlingDeserializer.class);
            props.put("spring.deserializer.key.function", CreateSerializedMessageHolder.class);
        } else {
            props.put("key.deserializer", EmptyKeyDeserializer.class);
        }
        if (this.kafkaMessagingMetrics != null) {
            props.put("bootstrap.servers", consumerBootstrapServers);
            props.put("consumerMetricsInterceptor.meterRegistry", this.kafkaMessagingMetrics);
            props.put("consumerMetricsInterceptor.applicationName", this.applicationName);
            interceptors.add(ConsumerMetricsInterceptor.class);
        }
        props.put("interceptor.classes", this.commaSeparatedClassList(interceptors));
        return props;
    }

    public Map<String, Object> producerConfig(String clusterName) {
        List callbacks;
        ArrayList interceptors = new ArrayList();
        Map<String, Object> props = this.commonConfig(clusterName);
        String producerBootstrapServers = this.kafkaProperties.getProducerBootstrapServers(clusterName);
        props.put("bootstrap.servers", PropertyRequirements.requireNonNullValue((String)"bootstrap.servers for producers", (Object)producerBootstrapServers));
        KafkaAvroSerdeProvider kafkaAvroSerdeProvider = (KafkaAvroSerdeProvider)this.beanFactory.getBean(this.beanNames.getKafkaAvroSerdeProviderBeanName(clusterName));
        props.putAll(kafkaAvroSerdeProvider.getSerdeProperties().avroSerializerProperties(clusterName));
        props.put("producerContractInterceptor.allowNoContractEvents", this.kafkaProperties.isPublishWithoutContractAllowed());
        props.put("producerContractInterceptor.allowNoContractEventsSilent", false);
        props.put("producerContractInterceptor.contractsValidator", this.contractsValidator);
        interceptors.add(ProducerContractInterceptor.class);
        props.put("clusternameheaderinterceptor.clustername", clusterName);
        interceptors.add(ProducerLoggerInterceptor.class);
        if (this.kafkaMessagingMetrics != null) {
            SignaturePublisherProperties signaturePublisherProperties = (SignaturePublisherProperties)this.beanFactory.getBean(SignaturePublisherProperties.class);
            props.put("bootstrap.servers", producerBootstrapServers);
            props.put("producerMetricsInterceptor.meterRegistry", this.kafkaMessagingMetrics);
            props.put("producerMetricsInterceptor.applicationName", this.applicationName);
            props.put("producerMetricsInterceptor.signature.enabled", signaturePublisherProperties.isSigningEnabled());
            interceptors.add(ProducerMetricsInterceptor.class);
        }
        if (!(callbacks = this.beanFactory.getBeanProvider(JeapKafkaMessageCallback.class).stream().toList()).isEmpty()) {
            props.put("jeap.kafka.callback.list", callbacks);
            interceptors.add(CallbackInterceptor.class);
        }
        props.put("interceptor.classes", this.commaSeparatedClassList(interceptors));
        return props;
    }

    private Map<String, Object> commonConfig(String clusterName) {
        KafkaAuthProperties kafkaAuthProperties = (KafkaAuthProperties)this.beanFactory.getBean(this.beanNames.getAuthPropertiesBeanName(clusterName));
        return new HashMap<String, Object>(kafkaAuthProperties.authenticationProperties(clusterName));
    }

    private String commaSeparatedClassList(List<Class<?>> classes) {
        return classes.stream().map(Class::getName).collect(Collectors.joining(","));
    }
}

