/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka;

import ch.admin.bit.jeap.messaging.kafka.errorhandling.ErrorServiceFailedHandler;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.ErrorServiceSender;
import ch.admin.bit.jeap.messaging.kafka.errorhandling.StackTraceHasher;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.tracing.TracerBridge;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@AutoConfiguration
public class KafkaConsumerConfiguration {
    private final KafkaProperties properties;
    private final ErrorServiceFailedHandler errorServiceFailedHandler;
    private final Optional<TracerBridge> tracerBridge;

    @Bean
    ErrorServiceSender errorServiceSender(BeanFactory beanFactory) {
        FixedBackOff retrySendingError = new FixedBackOff(this.properties.getErrorServiceRetryIntervalMs(), this.properties.getErrorServiceRetryAttempts());
        TracerBridge tracerBridgeOrNull = this.tracerBridge.orElse(null);
        StackTraceHasher stackTraceHasher = new StackTraceHasher(this.properties);
        return new ErrorServiceSender(beanFactory, this.properties, this.errorServiceFailedHandler, (BackOff)retrySendingError, tracerBridgeOrNull, stackTraceHasher);
    }

    @Bean
    @ConditionalOnMissingBean(value={CommonErrorHandler.class})
    CommonErrorHandler errorHandler(ErrorServiceSender errorServiceSender) {
        FixedBackOff noRetry = new FixedBackOff(0L, 0L);
        return new DefaultErrorHandler((ConsumerRecordRecoverer)errorServiceSender, (BackOff)noRetry);
    }

    @Generated
    public KafkaConsumerConfiguration(KafkaProperties properties, ErrorServiceFailedHandler errorServiceFailedHandler, Optional<TracerBridge> tracerBridge) {
        this.properties = properties;
        this.errorServiceFailedHandler = errorServiceFailedHandler;
        this.tracerBridge = tracerBridge;
    }
}

