/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.bean;

import ch.admin.bit.jeap.messaging.kafka.bean.JeapKafkaBeanDefinitionFactory;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class JeapKafkaBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanFactoryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapKafkaBeanRegistrar.class);
    private Environment environment;
    private BeanFactory beanFactory;
    private JeapKafkaBeanDefinitionFactory beanDefinitionFactory;
    private JeapKafkaBeanNames beanNames;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        JeapKafkaPropertyFactory propertyFactory = JeapKafkaPropertyFactory.create((Environment)this.environment, (BeanFactory)this.beanFactory);
        this.beanNames = new JeapKafkaBeanNames(propertyFactory.getJeapKafkaProperties().getDefaultClusterName());
        this.beanDefinitionFactory = new JeapKafkaBeanDefinitionFactory(this.beanFactory, propertyFactory.getSpringKafkaProperties(), this.beanNames, propertyFactory.getJeapKafkaProperties().getDefaultProducerClusterOverride());
        propertyFactory.getClusterNames().forEach(clusterName -> this.registerBeansForClusterName(registry, (String)clusterName));
    }

    private void registerBeansForClusterName(BeanDefinitionRegistry registry, String clusterName) {
        this.registerKafkaTemplate(registry, clusterName);
        this.registerKafkaProducerFactory(registry, clusterName);
        this.registerKafkaTransactionManager(registry, clusterName);
        this.registerKafkaConsumerFactory(registry, clusterName);
        this.registerKafkaAdmin(registry, clusterName);
        this.registerKafkaListenerContainerFactory(registry, clusterName);
    }

    private void registerKafkaTemplate(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getKafkaTemplateBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createKafkaTemplate(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerKafkaListenerContainerFactory(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getListenerContainerFactoryBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createListenerContainerFactory(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerKafkaAdmin(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getAdminBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createKafkaAdmin(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerKafkaProducerFactory(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getProducerFactoryBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createKafkaProducerFactory(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerKafkaTransactionManager(BeanDefinitionRegistry registry, String clusterName) {
        if (!this.environment.containsProperty("spring.kafka.producer.transaction-id-prefix")) {
            return;
        }
        String beanName = this.beanNames.getTransactionManagerBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createTransactionManager(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private void registerKafkaConsumerFactory(BeanDefinitionRegistry registry, String clusterName) {
        String beanName = this.beanNames.getConsumerFactoryBeanName(clusterName);
        if (!registry.containsBeanDefinition(beanName)) {
            GenericBeanDefinition beanDefinition = this.beanDefinitionFactory.createKafkaConsumerFactory(clusterName);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

