/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.interceptor;

import ch.admin.bit.jeap.messaging.kafka.interceptor.Callbacks;
import ch.admin.bit.jeap.messaging.kafka.interceptor.JeapKafkaMessageCallback;
import ch.admin.bit.jeap.messaging.model.Message;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackInterceptor
implements ProducerInterceptor<Object, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackInterceptor.class);
    public static final String CALLBACK_LIST = "jeap.kafka.callback.list";
    private List<JeapKafkaMessageCallback> callbacks = List.of();

    public void configure(Map<String, ?> configs) {
        List configuredCallbacks = (List)configs.get(CALLBACK_LIST);
        if (configuredCallbacks != null) {
            this.callbacks = configuredCallbacks;
        }
    }

    public ProducerRecord<Object, Object> onSend(ProducerRecord<Object, Object> record) {
        Object object = record.value();
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.callbacks.forEach(cb -> Callbacks.invokeCallback(msg, record.topic(), cb::onSend));
        }
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }
}

