/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.legacydecryption;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LegacyMessageDecryptor {
    private static final String OPENSSL_EVP_HEADER_MARKER = "Salted__";
    static final byte[] OPENSSL_EVP_HEADER_MARKER_BYTES = "Salted__".getBytes(StandardCharsets.US_ASCII);
    public static final int DEFAULT_SALT_LENGTH = 8;
    public static final int ITERATION_COUNT = 0;
    public static final String ALGORITHM = "PBEWITHMD5AND128BITAES-CBC-OPENSSL";
    public static final String PROVIDER = "BC";
    private static final int OPENSSL_EVP_HEADER_SIZE = 8;
    private final SecretKey secret;
    private final Cipher cipher;

    public LegacyMessageDecryptor(String passphrase) {
        if (passphrase == null || passphrase.isEmpty()) {
            throw new ConfigException("passphrase for Nifi-compatible decryption must be provided, set decrypt.passphrase");
        }
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM, PROVIDER);
            this.secret = factory.generateSecret(pbeKeySpec);
            this.cipher = Cipher.getInstance(ALGORITHM, PROVIDER);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new ConfigException("failure to initialize Cipher for Nifi-compatible decryption");
        }
    }

    public byte[] decryptMessage(byte[] payload) {
        byte[] header = Arrays.copyOf(payload, 8);
        if (!Arrays.equals(OPENSSL_EVP_HEADER_MARKER_BYTES, header)) {
            throw new SerializationException("did not find salt marker for payload decryption");
        }
        int saltStartIndex = 8;
        int saltEndIndex = 16;
        byte[] salt = Arrays.copyOfRange(payload, saltStartIndex, saltEndIndex);
        try {
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 0);
            this.cipher.init(2, (Key)this.secret, parameterSpec);
            return this.cipher.doFinal(Arrays.copyOfRange(payload, saltEndIndex, payload.length));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new SerializationException("failed to decrypt payload", (Throwable)e);
        }
    }
}

