/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.legacydecryption;

import ch.admin.bit.jeap.messaging.kafka.legacydecryption.LegacyMessageDecryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.kafka.common.errors.SerializationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LegacyMessageEncryptor {
    private static final Cipher CIPHER = LegacyMessageEncryptor.createCipher();
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private LegacyMessageEncryptor() {
    }

    public static byte[] encryptMessage(byte[] payload, String passphrase) throws GeneralSecurityException {
        byte[] encrypted;
        byte[] salt = new byte[8];
        SECURE_RANDOM.nextBytes(salt);
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEWITHMD5AND128BITAES-CBC-OPENSSL", "BC");
            SecretKey secret = factory.generateSecret(pbeKeySpec);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 0);
            CIPHER.init(1, (Key)secret, parameterSpec);
            encrypted = CIPHER.doFinal(payload);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new SerializationException("failed to decrypt payload", (Throwable)e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(LegacyMessageDecryptor.OPENSSL_EVP_HEADER_MARKER_BYTES);
            out.write(salt);
            out.write(encrypted);
        }
        catch (IOException e) {
            throw new SerializationException("failed to write salt and encrypted payload", (Throwable)e);
        }
        return out.toByteArray();
    }

    private static Cipher createCipher() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        return Cipher.getInstance("PBEWITHMD5AND128BITAES-CBC-OPENSSL", "BC");
    }
}

