/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.common;

import ch.admin.bit.jeap.messaging.kafka.signature.common.CertificateHelper;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;

public class SignatureCertificate {
    private final X509Certificate certificate;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;

    public String getSubjectDistinguishedName() {
        return this.certificate.getSubjectX500Principal().getName();
    }

    public byte[] getSerialNumber() {
        return this.certificate.getSerialNumber().toByteArray();
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public boolean isExpired() {
        LocalDateTime now = LocalDateTime.now();
        return now.isAfter(this.validTo);
    }

    public boolean isNotYetValid() {
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.validFrom);
    }

    public long getValidityRemainingDays() {
        LocalDateTime now = LocalDateTime.now();
        return ChronoUnit.DAYS.between(now, this.validTo);
    }

    public static SignatureCertificate fromBytes(byte[] certificateBytes) {
        X509Certificate certificate = CertificateHelper.generateCertificate(certificateBytes);
        return new SignatureCertificate(certificate, SignatureCertificate.convertToLocalDate(certificate.getNotBefore()), SignatureCertificate.convertToLocalDate(certificate.getNotAfter()));
    }

    private static LocalDateTime convertToLocalDate(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public String toString() {
        return this.certificate.toString();
    }

    @Generated
    public SignatureCertificate(X509Certificate certificate, LocalDateTime validFrom, LocalDateTime validTo) {
        this.certificate = certificate;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }
}

