/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.subscriber;

import ch.admin.bit.jeap.messaging.avro.errorevent.MessageHandlerExceptionInformation;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureAuthenticityService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.common.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateValidationException;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureValidationException;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.SignatureAuthenticityMessageException;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.CertificateAndSignatureVerifier;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SignatureCertificateWithChainValidity;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberCertificatesContainer;
import ch.admin.bit.jeap.messaging.kafka.signature.subscriber.SubscriberValidationPropertiesContainer;
import ch.admin.bit.jeap.messaging.model.Message;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignatureAuthenticityService
implements SignatureAuthenticityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSignatureAuthenticityService.class);
    private final SubscriberValidationPropertiesContainer validationPropertiesContainer;
    private final CertificateAndSignatureVerifier certificateAndSignatureVerifier;
    private final SignatureMetricsService signatureMetricsService;
    private final SubscriberCertificatesContainer subscriberCertificatesContainer;
    private AtomicLong signatureRequiredState;

    public DefaultSignatureAuthenticityService(SubscriberValidationPropertiesContainer validationPropertiesContainer, CertificateAndSignatureVerifier certificateAndSignatureVerifier, SubscriberCertificatesContainer subscriberCertificatesContainer, Optional<SignatureMetricsService> signatureMetricsService) {
        this.validationPropertiesContainer = validationPropertiesContainer;
        this.certificateAndSignatureVerifier = certificateAndSignatureVerifier;
        this.signatureMetricsService = signatureMetricsService.orElse(null);
        this.subscriberCertificatesContainer = subscriberCertificatesContainer;
        log.info("SignatureAuthenticityService initialized, requireSignature (strict mode): {}", (Object)validationPropertiesContainer.isSignatureRequired());
    }

    @PostConstruct
    void init() {
        CryptoProviderHelper.installCryptoProvider();
        this.initMetrics();
    }

    @Override
    public void checkAuthenticityValue(Object deserialized, Headers headers, byte[] bytesToValidate) {
        if (deserialized instanceof Message) {
            Message message = (Message)deserialized;
            if (headers == null) {
                throw MessageSignatureValidationException.headersMissing(true);
            }
            String messageTypeName = message.getType().getName();
            try {
                this.doCheckAuthenticityValue(message, headers, bytesToValidate);
                this.recordSignatureValidation(messageTypeName, true);
            }
            catch (Exception exception) {
                this.recordSignatureValidation(messageTypeName, false);
                if (exception instanceof MessageHandlerExceptionInformation) {
                    MessageHandlerExceptionInformation messageHandlerExceptionInformation = (MessageHandlerExceptionInformation)exception;
                    throw SignatureAuthenticityMessageException.fromMessageHandlerExceptionInformation(message, messageHandlerExceptionInformation, exception);
                }
                throw exception;
            }
        } else {
            if (this.validationPropertiesContainer.allowNonJeapMessages()) {
                log.debug("Message is not of type Message, but non-Jeap messages are allowed, skipping authenticity check: {}", (Object)(deserialized == null ? "null" : deserialized.getClass().getName()));
                return;
            }
            throw MessageSignatureValidationException.notAllowedNonJeapMessageType(deserialized);
        }
    }

    @Override
    public void checkAuthenticityKey(Headers headers, byte[] bytesToValidate) {
        if (headers == null) {
            throw MessageSignatureValidationException.headersMissing(true);
        }
        Header certificateHeader = headers.lastHeader("jeap-cert");
        Header signatureHeader = headers.lastHeader("jeap-sign-key");
        boolean signatureRequired = false;
        this.validateHeaders(signatureRequired, signatureHeader, certificateHeader, "unknown", "unknown");
        if (certificateHeader != null) {
            SignatureCertificateWithChainValidity cert = this.getCertificate(certificateHeader.value(), this.validationPropertiesContainer.isSignatureRequired());
            if (cert == null) {
                log.warn("Message Key from service unknown has no valid certificate, but signature is not required");
                return;
            }
            boolean result = this.certificateAndSignatureVerifier.verifyKeySignature(bytesToValidate, signatureHeader.value(), cert);
            if (!result) {
                throw MessageSignatureValidationException.invalidSignatureKey();
            }
        }
    }

    private void doCheckAuthenticityValue(Message message, Headers headers, byte[] bytesToValidate) {
        String messageTypeName = message.getType().getName();
        String service = message.getPublisher().getService();
        Header certificateHeader = headers.lastHeader("jeap-cert");
        Header signatureHeader = headers.lastHeader("jeap-sign");
        boolean signatureRequired = this.validationPropertiesContainer.isSignatureRequired(messageTypeName);
        this.validateHeaders(signatureRequired, signatureHeader, certificateHeader, messageTypeName, service);
        if (certificateHeader != null) {
            SignatureCertificateWithChainValidity cert = this.getCertificate(certificateHeader.value(), this.validationPropertiesContainer.isSignatureRequired());
            if (cert == null) {
                log.warn("Message {} from service {} has no valid certificate, but signature is not required", (Object)messageTypeName, (Object)service);
                return;
            }
            this.validateAllowedPublisher(messageTypeName, service, cert);
            boolean result = this.certificateAndSignatureVerifier.verifyValueSignature(service, bytesToValidate, signatureHeader.value(), cert);
            if (!result) {
                throw MessageSignatureValidationException.invalidSignatureValue(messageTypeName, service);
            }
        }
    }

    private void validateAllowedPublisher(String messageTypeName, String service, SignatureCertificateWithChainValidity cert) {
        boolean publisherAllowedForMessage = this.validationPropertiesContainer.isPublisherAllowedForMessage(messageTypeName, service);
        if (!publisherAllowedForMessage && !this.certificateAndSignatureVerifier.isPrivilegedProducer(cert)) {
            throw MessageSignatureValidationException.publisherNotAllowed(messageTypeName, service);
        }
    }

    private SignatureCertificateWithChainValidity getCertificate(byte[] certificateSerialNumber, boolean signatureRequired) {
        SignatureCertificateWithChainValidity certificateWithChainValidity = this.subscriberCertificatesContainer.getCertificateWithSerialNumber(certificateSerialNumber);
        if (certificateWithChainValidity == null && signatureRequired) {
            throw CertificateValidationException.certificateNotFound(certificateSerialNumber);
        }
        return certificateWithChainValidity;
    }

    private void validateHeaders(boolean signatureRequired, Header signatureHeader, Header certificateHeader, String messageTypeName, String service) {
        if (signatureRequired) {
            if (signatureHeader == null || certificateHeader == null) {
                throw MessageSignatureValidationException.strictModeSignatureHeadersMissing(messageTypeName, service);
            }
        } else {
            if (signatureHeader == null && certificateHeader != null) {
                throw MessageSignatureValidationException.signatureHeaderMissing(messageTypeName, service);
            }
            if (signatureHeader != null && certificateHeader == null) {
                throw MessageSignatureValidationException.certificateHeaderMissing(messageTypeName, service);
            }
        }
    }

    private void recordSignatureValidation(String keyMessageTypeMetricName, boolean result) {
        if (this.signatureMetricsService != null) {
            this.signatureMetricsService.recordSignatureValidation(keyMessageTypeMetricName, result);
        }
    }

    private void initMetrics() {
        this.signatureRequiredState = new AtomicLong(this.validationPropertiesContainer.isSignatureRequired() ? 1L : 0L);
        if (this.signatureMetricsService != null) {
            this.signatureMetricsService.initSignatureRequiredMetricName(() -> this.signatureRequiredState.get());
        }
    }
}

