/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.contract;

import ch.admin.bit.jeap.messaging.contract.v2.Contract;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractValidationExemptions;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsProvider;
import ch.admin.bit.jeap.messaging.kafka.contract.ContractsValidator;
import ch.admin.bit.jeap.messaging.kafka.contract.MessageTypeIdentificator;
import ch.admin.bit.jeap.messaging.kafka.contract.NoContractException;
import ch.admin.bit.jeap.messaging.model.MessageType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DefaultContractsValidator
implements ContractsValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultContractsValidator.class);
    private static final String ROLE_CONSUMER = "consumer";
    private static final String ROLE_PRODUCER = "producer";
    private final String appName;
    private final Map<String, List<Contract>> consumerContracts;
    private final Map<MessageTypeIdentificator, List<Contract>> producerContracts;

    public DefaultContractsValidator(@Value(value="${spring.application.name}") String appName, ContractsProvider contractsProvider) {
        this.appName = appName;
        this.consumerContracts = contractsProvider.getContracts().stream().filter(c -> appName.equals(c.getAppName())).filter(c -> c.getRole().equalsIgnoreCase(ROLE_CONSUMER)).collect(Collectors.groupingBy(Contract::getMessageTypeName));
        this.producerContracts = contractsProvider.getContracts().stream().filter(c -> appName.equals(c.getAppName())).filter(c -> c.getRole().equalsIgnoreCase(ROLE_PRODUCER)).collect(Collectors.groupingBy(MessageTypeIdentificator::from, Collectors.toList()));
    }

    @Override
    public void ensurePublisherContract(MessageType messageType, String topic) {
        if (ContractValidationExemptions.isExemptedFromSenderValidation(messageType)) {
            return;
        }
        if (!this.hasProducerContractFor(messageType, topic)) {
            throw NoContractException.noContract(this.appName, ROLE_PRODUCER, messageType, topic);
        }
    }

    @Override
    public void ensureConsumerContract(String messageTypeName, String topic) {
        if (ContractValidationExemptions.isExemptedFromReceiverValidation(messageTypeName)) {
            return;
        }
        if (!this.hasConsumerContractFor(messageTypeName, topic)) {
            throw NoContractException.noContract(this.appName, ROLE_CONSUMER, messageTypeName, topic);
        }
    }

    private boolean hasProducerContractFor(MessageType messageType, String topic) {
        return this.producerContracts.getOrDefault(MessageTypeIdentificator.from(messageType), List.of()).stream().flatMap(contract -> Arrays.stream(contract.getTopics())).anyMatch(contractTopic -> contractTopic.equals(topic));
    }

    private boolean hasConsumerContractFor(String messageTypeName, String topic) {
        return this.consumerContracts.getOrDefault(messageTypeName, List.of()).stream().flatMap(contract -> Arrays.stream(contract.getTopics())).anyMatch(contractTopic -> contractTopic.equals(topic));
    }
}

