/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.metrics;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.MessageVersionAccessor;
import ch.admin.bit.jeap.messaging.kafka.metrics.KafkaMessagingMetrics;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ProducerMetricsInterceptor
implements ProducerInterceptor<Object, Object> {
    public static final String METER_REGISTRY = "producerMetricsInterceptor.meterRegistry";
    public static final String APPLICATION_NAME = "producerMetricsInterceptor.applicationName";
    private KafkaMessagingMetrics kafkaMessagingMetrics;
    private String applicationName;
    private String boostrapServers;

    public void configure(Map<String, ?> configs) {
        this.kafkaMessagingMetrics = (KafkaMessagingMetrics)configs.get(METER_REGISTRY);
        this.applicationName = (String)configs.get(APPLICATION_NAME);
        this.boostrapServers = (String)configs.get("bootstrap.servers");
    }

    public ProducerRecord<Object, Object> onSend(ProducerRecord<Object, Object> record) {
        String version;
        String type;
        Object object = record.value();
        if (object instanceof AvroMessage) {
            AvroMessage avroMessage = (AvroMessage)object;
            type = avroMessage.getType().getName();
            version = MessageVersionAccessor.getGeneratedVersion((Class)avroMessage.getClass());
        } else {
            type = record.value().getClass().getSimpleName();
            version = "na";
        }
        this.kafkaMessagingMetrics.incrementSend(this.boostrapServers, this.applicationName, record.topic(), type, version);
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }
}

