/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.errorhandling;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;

@AutoConfiguration
public class ErrorServiceFailedHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorServiceFailedHandler.class);
    private final ApplicationContext ctx;

    public void handle(Throwable e) {
        int exitCode = -1;
        log.error("Cannot connect to error service after an event handler has failed. There is no safe way how this application can proceed, therefore shutting it down", e);
        SpringApplication.exit((ApplicationContext)this.ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> exitCode});
        log.error("Spring application did not shut down normally, forcefully close it", e);
        System.exit(exitCode);
    }

    @Generated
    public ErrorServiceFailedHandler(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

