/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.metrics;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.MessageVersionAccessor;
import ch.admin.bit.jeap.messaging.kafka.metrics.KafkaMessagingMetrics;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class ConsumerMetricsInterceptor
implements ConsumerInterceptor<Object, Object> {
    public static final String METER_REGISTRY = "consumerMetricsInterceptor.meterRegistry";
    public static final String APPLICATION_NAME = "consumerMetricsInterceptor.applicationName";
    private KafkaMessagingMetrics kafkaMessagingMetrics;
    private String applicationName;
    private String boostrapServers;

    public void configure(Map<String, ?> configs) {
        this.kafkaMessagingMetrics = (KafkaMessagingMetrics)configs.get(METER_REGISTRY);
        this.applicationName = (String)configs.get(APPLICATION_NAME);
        this.boostrapServers = (String)configs.get("bootstrap.servers");
    }

    public ConsumerRecords<Object, Object> onConsume(ConsumerRecords<Object, Object> records) {
        records.forEach(this::onConsume);
        return records;
    }

    private void onConsume(ConsumerRecord<Object, Object> message) {
        String version;
        String type;
        Object object = message.value();
        if (object instanceof AvroMessage) {
            AvroMessage avroMessage = (AvroMessage)object;
            type = avroMessage.getType().getName();
            version = MessageVersionAccessor.getGeneratedVersion((Class)avroMessage.getClass());
        } else {
            type = message.value().getClass().getSimpleName();
            version = "na";
        }
        this.kafkaMessagingMetrics.incrementConsume(this.boostrapServers, this.applicationName, message.topic(), type, version);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }
}

