/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.SignatureMetricsService;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureProducerProperties;
import ch.admin.bit.jeap.messaging.kafka.signature.SignatureService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration
@EnableConfigurationProperties(value={SignatureProducerProperties.class})
@EnableScheduling
@ComponentScan
@Import(value={SignatureMetricConfiguration.class})
public class SignatureConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="jeap.messaging.authentication.publisher", name={"signature-key"})
    public SignatureService signatureService(SignatureProducerProperties signatureProducerProperties, TaskScheduler taskScheduler, Optional<SignatureMetricsService> signatureMetricsService, @Value(value="${spring.application.name}") String applicationName) {
        return new SignatureService(signatureProducerProperties, taskScheduler, signatureMetricsService, applicationName);
    }

    @Configuration
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public static class SignatureMetricConfiguration {
        @Bean
        public SignatureMetricsService signatureMetricsService(MeterRegistry meterRegistry, @Value(value="${spring.application.name}") String applicationName) {
            return new SignatureMetricsService(meterRegistry, applicationName);
        }
    }
}

