/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.ByteSigner;
import org.apache.kafka.common.header.Headers;

public class SignatureInjector {
    private static final String SIGNATURE_PAYLOAD_HEADER_KEY = "jeap-sign";
    private static final String SIGNATURE_KEY_HEADER_KEY = "jeap-sign-key";
    private static final String SIGNATURE_CERTIFICATE_HEADER_KEY = "jeap-cert";
    private final ByteSigner byteSigner;
    private final byte[] certificateSerialNumber;

    SignatureInjector(ByteSigner byteSigner, byte[] certificateSerialNumber) {
        this.byteSigner = byteSigner;
        this.certificateSerialNumber = certificateSerialNumber;
    }

    public void injectSignature(Headers headers, byte[] bytesToSign, boolean isKey) {
        byte[] signature = this.byteSigner.createSignature(bytesToSign);
        headers.add(this.determineHeaderKey(isKey), signature);
        if (!isKey) {
            headers.add(SIGNATURE_CERTIFICATE_HEADER_KEY, this.certificateSerialNumber);
        }
    }

    private String determineHeaderKey(boolean isKey) {
        return isKey ? SIGNATURE_KEY_HEADER_KEY : SIGNATURE_PAYLOAD_HEADER_KEY;
    }
}

