/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.errorhandling;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ClusterNameHeaderInterceptor
implements ConsumerInterceptor<Object, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterNameHeaderInterceptor.class);
    public static final String CLUSTER_NAME_CONFIG = "clusternameheaderinterceptor.clustername";
    static final String CLUSTER_NAME_HEADER = "jeapClusterName";
    private byte[] clusterName;

    public static String getClusterName(ConsumerRecord<?, ?> record) {
        Header header = record.headers().lastHeader(CLUSTER_NAME_HEADER);
        if (header != null) {
            return new String(header.value(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public ConsumerRecords<Object, Object> onConsume(ConsumerRecords<Object, Object> records) {
        records.forEach(r -> r.headers().add(CLUSTER_NAME_HEADER, this.clusterName));
        return records;
    }

    public void configure(Map<String, ?> configs) {
        String clusterNameConfig = (String)configs.get(CLUSTER_NAME_CONFIG);
        if (!StringUtils.hasText((String)clusterNameConfig)) {
            throw new IllegalStateException("Mandatory config property %s is missing".formatted(CLUSTER_NAME_CONFIG));
        }
        this.clusterName = clusterNameConfig.getBytes(StandardCharsets.UTF_8);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }
}

