/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.log;

import ch.admin.bit.jeap.messaging.kafka.log.MessageLogger;
import ch.admin.bit.jeap.messaging.kafka.log.TopicLogger;
import java.util.Map;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ProducerLoggerInterceptor
implements ProducerInterceptor<Object, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerLoggerInterceptor.class);
    public static final String CLUSTER_NAME_CONFIG = "clusternameheaderinterceptor.clustername";
    private String clusterName;

    public void configure(Map<String, ?> configs) {
        String clusterName = (String)configs.get(CLUSTER_NAME_CONFIG);
        if (!StringUtils.hasText((String)clusterName)) {
            throw new IllegalStateException("Mandatory config property %s is missing".formatted(CLUSTER_NAME_CONFIG));
        }
        this.clusterName = clusterName;
    }

    public ProducerRecord<Object, Object> onSend(ProducerRecord<Object, Object> record) {
        if (log.isInfoEnabled()) {
            log.info("Published {} to {} using cluster {}", new Object[]{MessageLogger.message(record.value()), TopicLogger.topic(record), this.clusterName});
        }
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        if (exception == null) {
            log.debug("Kafka acknowledged offset {} on {}", (Object)StructuredArguments.value((String)"offset", (Object)metadata.offset()), (Object)TopicLogger.topic(metadata));
        } else {
            log.error("Publishing events on {} failed with {}", new Object[]{TopicLogger.topic(metadata), StructuredArguments.value((String)"exception", exception.getClass()), exception});
        }
    }

    public void close() {
    }
}

