/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.CryptoProviderHelper;
import ch.admin.bit.jeap.messaging.kafka.signature.PrivateKeyFactory;
import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.MessageSignatureException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSigner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByteSigner.class);
    private static final String SIGN_ALGORITHM = "SHA256withRSA";
    private final PrivateKey privateKey;

    public ByteSigner(byte[] privateKeyBytes) {
        this(PrivateKeyFactory.createPrivateKey(privateKeyBytes));
    }

    ByteSigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] createSignature(byte[] bytes) {
        try {
            Signature signature = this.createSignature();
            signature.update(bytes);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            log.error("Error while signing", (Throwable)e);
            throw MessageSignatureException.signatureCreationFailed(e);
        }
    }

    private Signature createSignature() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature signature = CryptoProviderHelper.correttoEnabled ? Signature.getInstance(SIGN_ALGORITHM, "AmazonCorrettoCryptoProvider") : Signature.getInstance(SIGN_ALGORITHM);
        signature.initSign(this.privateKey);
        return signature;
    }
}

