/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivateKeyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrivateKeyFactory.class);
    private static final String ALGORITHM = "RSA";

    public static PrivateKey createPrivateKey(byte[] privateKeyBytes) {
        try {
            return PrivateKeyFactory.doCreatePrivateKey(privateKeyBytes);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw KeyException.couldNotCreateKeyException(e);
        }
    }

    private static PrivateKey doCreatePrivateKey(byte[] privateKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            String pemContent = new String(privateKeyBytes).replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            byte[] keyBytes = Base64.getDecoder().decode(pemContent);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            return PrivateKeyFactory.createPrivateKey(keySpec);
        }
        catch (InvalidKeySpecException e) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            return PrivateKeyFactory.createPrivateKey(keySpec);
        }
    }

    private static PrivateKey createPrivateKey(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        return keyFactory.generatePrivate(keySpec);
    }

    @Generated
    private PrivateKeyFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

