/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature;

import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateException;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;

public class SignatureCertificate {
    private final String subjectDistinguishedName;
    private final byte[] serialNumber;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;

    public boolean isExpired() {
        LocalDateTime now = LocalDateTime.now();
        return now.isAfter(this.validTo);
    }

    public boolean isNotYetValid() {
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.validFrom);
    }

    public long getValidityRemainingDays() {
        LocalDateTime now = LocalDateTime.now();
        return ChronoUnit.DAYS.between(now, this.validTo);
    }

    public static SignatureCertificate fromBytes(byte[] certificateBytes) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificateBytes));
            String subjectDistinguishedName = certificate.getSubjectX500Principal().getName();
            return new SignatureCertificate(subjectDistinguishedName, certificate.getSerialNumber().toByteArray(), SignatureCertificate.convertToLocalDate(certificate.getNotBefore()), SignatureCertificate.convertToLocalDate(certificate.getNotAfter()));
        }
        catch (java.security.cert.CertificateException exception) {
            throw CertificateException.creatingCertificateFailed(exception);
        }
    }

    private static LocalDateTime convertToLocalDate(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Generated
    public SignatureCertificate(String subjectDistinguishedName, byte[] serialNumber, LocalDateTime validFrom, LocalDateTime validTo) {
        this.subjectDistinguishedName = subjectDistinguishedName;
        this.serialNumber = serialNumber;
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    @Generated
    public String getSubjectDistinguishedName() {
        return this.subjectDistinguishedName;
    }

    @Generated
    public byte[] getSerialNumber() {
        return this.serialNumber;
    }
}

