/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.messaging.kafka.signature.common;

import ch.admin.bit.jeap.messaging.kafka.signature.exceptions.CertificateException;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HexFormat;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateHelper.class);
    private static final String CERTIFICATE_FACTORY_INSTANCE_NAME = "X.509";
    private static final String CERT_PATH_VALIDATOR_ALGORITHM = "PKIX";
    private static final String COMMON_NAME = "CN";

    public static String getCommonName(String distinguishedName) {
        try {
            LdapName ldapName = new LdapName(distinguishedName);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase(COMMON_NAME)) continue;
                return (String)rdn.getValue();
            }
            return null;
        }
        catch (InvalidNameException e) {
            log.error("Could not parse CN from distinguishedName", (Throwable)e);
            throw CertificateException.parsingCertificateFailed(e);
        }
    }

    public static String serialNumberHexString(byte[] serialNumber) {
        return HexFormat.ofDelimiter(" ").formatHex(serialNumber);
    }

    static X509Certificate generateCertificate(byte[] certificateBytes) {
        try {
            CertificateFactory certificateFactory = CertificateHelper.getCertificateFactory();
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificateBytes));
        }
        catch (java.security.cert.CertificateException exception) {
            throw CertificateException.creatingCertificateFailed(exception);
        }
    }

    public static void validateCertificateChain(List<X509Certificate> certificates) {
        try {
            CertPathValidator validator = CertPathValidator.getInstance(CERT_PATH_VALIDATOR_ALGORITHM);
            CertificateFactory certFactory = CertificateHelper.getCertificateFactory();
            CertPath certPath = certFactory.generateCertPath(certificates);
            TrustAnchor trustAnchor = new TrustAnchor(certificates.getLast(), null);
            PKIXParameters params = new PKIXParameters(Set.of(trustAnchor));
            params.setRevocationEnabled(false);
            validator.validate(certPath, params);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathValidatorException | java.security.cert.CertificateException exception) {
            throw CertificateException.validatingCertificateChainFailed(exception);
        }
    }

    private static CertificateFactory getCertificateFactory() throws java.security.cert.CertificateException {
        return CertificateFactory.getInstance(CERTIFICATE_FACTORY_INSTANCE_NAME);
    }

    @Generated
    private CertificateHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

